/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.modhelpers;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThaumcraftHelper {
    private static Map<String, ? extends Object> aspects = null;
    private static Method registerItem = null;
    private static Method registerEntity = null;
    private static Class<?> AspectList = null;
    private static Constructor<?> newAspectList = null;
    private static Method addAspect = null;
    private static boolean works = false;

    private ThaumcraftHelper() {
    }

    private static void parseAspects(Object aspectList, String toadd) throws Throwable {
        if (!works) {
            return;
        }
        if (!(toadd = toadd.trim()).isEmpty()) {
            String[] list = toadd.split(",");
            int e = list.length;
            for (int i = 0; i < e; ++i) {
                String[] temp = list[i].trim().split(" ", 2);
                if (temp.length != 2) {
                    FMLLog.bigWarning((String)"[CoFH Thaumcraft Helper] Invalid aspect entry '%s'", (Object[])new Object[]{list[i]});
                    continue;
                }
                String aspect = temp[1].trim();
                if (aspects.containsKey(aspect)) {
                    addAspect.invoke(aspectList, aspects.get(aspect), Integer.valueOf(temp[0], 10));
                    continue;
                }
                FMLLog.fine((String)"[CoFH Thaumcraft Helper] %s aspect missing.", (Object[])new Object[]{temp[1]});
            }
        }
    }

    public static void parseAspects(String entity, String toadd) throws Throwable {
        if (!works) {
            return;
        }
        Object aspectList = AspectList.newInstance();
        ThaumcraftHelper.parseAspects(aspectList, toadd);
        registerEntity.invoke(null, entity, aspectList, null);
    }

    public static void parseAspects(ItemStack item, String toadd, boolean craftedAspects) throws Throwable {
        if (!works) {
            return;
        }
        Object aspectList = craftedAspects ? newAspectList.newInstance(item) : AspectList.newInstance();
        ThaumcraftHelper.parseAspects(aspectList, toadd);
        registerItem.invoke(null, item, aspectList);
    }

    public static void parseAspects(ItemStack item, String toadd) throws Throwable {
        ThaumcraftHelper.parseAspects(item, toadd, true);
    }

    public static void parseAspects(Item item, int meta, String toadd, boolean craftedAspects) throws Throwable {
        ThaumcraftHelper.parseAspects(new ItemStack(item, 1, meta), toadd, craftedAspects);
    }

    public static void parseAspects(Item item, String toadd, boolean craftedAspects) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, toadd, craftedAspects);
    }

    public static void parseAspects(Item item, int meta, String toadd) throws Throwable {
        ThaumcraftHelper.parseAspects(item, meta, toadd, true);
    }

    public static void parseAspects(Item item, String toadd) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, toadd, true);
    }

    public static void parseAspects(Block item, int meta, String toadd, boolean craftedAspects) throws Throwable {
        ThaumcraftHelper.parseAspects(new ItemStack(item, 1, meta), toadd, craftedAspects);
    }

    public static void parseAspects(Block item, String toadd, boolean craftedAspects) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, toadd, craftedAspects);
    }

    public static void parseAspects(Block item, int meta, String toadd) throws Throwable {
        ThaumcraftHelper.parseAspects(item, meta, toadd, true);
    }

    public static void parseAspects(Block item, String toadd) throws Throwable {
        ThaumcraftHelper.parseAspects(item, Short.MAX_VALUE, toadd, true);
    }

    static {
        try {
            Class<?> Aspect = Class.forName("thaumcraft.api.aspects.Aspect");
            aspects = (Map)Aspect.getDeclaredField("aspects").get(null);
            Class<?> ThaumcraftApi = Class.forName("thaumcraft.api.ThaumcraftApi");
            AspectList = Class.forName("thaumcraft.api.aspects.AspectList");
            registerItem = ThaumcraftApi.getDeclaredMethod("registerObjectTag", ItemStack.class, AspectList);
            Class<?> EntityTagsNBT = Class.forName("[Lthaumcraft.api.ThaumcraftApi$EntityTagsNBT;");
            registerEntity = ThaumcraftApi.getDeclaredMethod("registerEntityTag", String.class, AspectList, EntityTagsNBT);
            addAspect = AspectList.getDeclaredMethod("add", Aspect, Integer.TYPE);
            newAspectList = AspectList.getDeclaredConstructor(ItemStack.class);
            works = true;
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }
}

