/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.render.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.common.tiles.TileGearBox;

@SideOnly(value=Side.CLIENT)
public class ModelGearbox
extends ModelBase {
    private static final float HALF_TURN = 1.5707964f;
    private static final float QUARTER_TURN = 0.7853982f;
    private static final float EDGE_DISTANCE = 3.12f;
    private static final int SIDE_COUNT = ForgeDirection.VALID_DIRECTIONS.length;
    private final ModelRenderer Transmission;
    private final ModelRenderer Shaft;
    private final ModelRenderer Spoke;
    private float rotationAngle = 0.0f;
    private final SideTransformation[] transformations;

    public ModelGearbox() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.Transmission = new ModelRenderer((ModelBase)this, 1, 0);
        this.Transmission.func_78789_a(0.0f, 0.0f, 0.0f, 7, 7, 7);
        this.Transmission.func_78793_a(-3.5f, -3.5f, -3.5f);
        this.Transmission.func_78787_b(64, 64);
        this.Transmission.field_78809_i = true;
        this.Shaft = new ModelRenderer((ModelBase)this, 1, 15);
        this.Shaft.func_78789_a(-1.5f, -0.5f, -0.5f, 3, 1, 1);
        this.Shaft.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Shaft.func_78787_b(64, 64);
        this.Shaft.field_78809_i = true;
        this.Spoke = new ModelRenderer((ModelBase)this, 1, 18);
        this.Spoke.func_78789_a(-0.5f, -3.5f, -0.5f, 1, 7, 1);
        this.Spoke.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Spoke.func_78787_b(64, 64);
        this.Spoke.field_78809_i = true;
        this.transformations = new SideTransformation[ForgeDirection.VALID_DIRECTIONS.length];
        this.transformations[ForgeDirection.EAST.ordinal()] = new SideTransformation(0.0f, 0.0f, 3.12f, 0.0f, 0.0f);
        this.transformations[ForgeDirection.WEST.ordinal()] = new SideTransformation(0.0f, 0.0f, -3.12f, 0.0f, 0.0f);
        this.transformations[ForgeDirection.UP.ordinal()] = new SideTransformation(0.0f, 1.5707964f, 0.0f, 3.12f, 0.0f);
        this.transformations[ForgeDirection.DOWN.ordinal()] = new SideTransformation(0.0f, 1.5707964f, 0.0f, -3.12f, 0.0f);
        this.transformations[ForgeDirection.SOUTH.ordinal()] = new SideTransformation(1.5707964f, 0.0f, 0.0f, 0.0f, 3.12f);
        this.transformations[ForgeDirection.NORTH.ordinal()] = new SideTransformation(1.5707964f, 0.0f, 0.0f, 0.0f, -3.12f);
    }

    private void renderShaft(int side, float f5) {
        SideTransformation sideTransform = this.transformations[side];
        if (sideTransform.hasShaft) {
            this.Shaft.field_78796_g = sideTransform.rotateAngleY;
            this.Shaft.field_78808_h = sideTransform.rotateAngleZ;
            this.Shaft.field_82906_o = sideTransform.shaftOffsetX;
            this.Shaft.field_82908_p = sideTransform.shaftOffsetY;
            this.Shaft.field_82907_q = sideTransform.shaftOffsetZ;
            this.Shaft.func_78785_a(f5);
            if (sideTransform.hasGear) {
                this.Spoke.field_78796_g = sideTransform.rotateAngleY;
                this.Spoke.field_78808_h = sideTransform.rotateAngleZ;
                this.Spoke.field_82906_o = sideTransform.spokeOffsetX;
                this.Spoke.field_82908_p = sideTransform.spokeOffsetY;
                this.Spoke.field_82907_q = sideTransform.spokeOffsetZ;
                this.Spoke.field_78795_f += 0.7853982f;
                this.Spoke.func_78785_a(f5);
                this.Spoke.field_78795_f += 0.7853982f;
                this.Spoke.func_78785_a(f5);
                this.Spoke.field_78795_f += 0.7853982f;
                this.Spoke.func_78785_a(f5);
                this.Spoke.field_78795_f += 0.7853982f;
                this.Spoke.func_78785_a(f5);
            }
        }
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.Transmission.func_78785_a(f5);
        this.Shaft.field_78795_f = this.rotationAngle;
        this.Spoke.field_78795_f = this.rotationAngle;
        for (int side = 0; side < SIDE_COUNT; ++side) {
            this.renderShaft(side, f5);
        }
    }

    public void updateToTileEntity(TileGearBox gearboxTile) {
        for (int side = 0; side < SIDE_COUNT; ++side) {
            boolean withGear = !gearboxTile.sideIsFacingCrankable[side];
            this.transformations[side].setIsRendered(true, withGear);
        }
        this.rotationAngle = gearboxTile.shaftRotation;
    }

    private class SideTransformation {
        private static final float SPOKE_OFFSET = 1.2f;
        public final float rotateAngleY;
        public final float rotateAngleZ;
        public final float shaftOffsetX;
        public final float shaftOffsetY;
        public final float shaftOffsetZ;
        public final float spokeOffsetX;
        public final float spokeOffsetY;
        public final float spokeOffsetZ;
        boolean hasShaft = true;
        boolean hasGear = false;

        public SideTransformation(float rotateAngleY, float rotateAngleZ, float offsetX, float offsetY, float offsetZ) {
            this.rotateAngleY = rotateAngleY;
            this.rotateAngleZ = rotateAngleZ;
            this.shaftOffsetX = offsetX;
            this.shaftOffsetY = offsetY;
            this.shaftOffsetZ = offsetZ;
            this.spokeOffsetX = offsetX * 1.2f;
            this.spokeOffsetY = offsetY * 1.2f;
            this.spokeOffsetZ = offsetZ * 1.2f;
        }

        public void setIsRendered(boolean shaft, boolean gear) {
            this.hasShaft = shaft;
            this.hasGear = gear;
        }
    }
}

