/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.entities;

import appeng.api.AEApi;
import appeng.items.parts.ItemFacade;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumicenergistics.api.entities.IGolemHookHandler;
import thaumicenergistics.api.entities.IGolemHookSyncRegistry;
import thaumicenergistics.client.render.model.ModelGolemWifiBackpack;
import thaumicenergistics.common.entities.AIGolemWifiEssentia;
import thaumicenergistics.common.entities.AIGolemWifiFill;
import thaumicenergistics.common.entities.AIGolemWifiGather;
import thaumicenergistics.common.entities.AIGolemWifiLiquid;
import thaumicenergistics.common.integration.tc.GolemCoreType;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.items.ItemGolemWirelessBackpack;
import thaumicenergistics.common.utils.EffectiveSide;

public class WirelessGolemHandler
implements IGolemHookHandler {
    private static WirelessGolemHandler INSTANCE = null;
    private static final String NBTKEY_WIFI_KEY = "wifiBackpackKey";
    private static final String NBTKEY_FACADE = "facade";
    private static final Character SYNCFLAG_HAS_WIFI_IN_RANGE = Character.valueOf('i');
    private static final Character SYNCFLAG_HAS_WIFI_OUT_OF_RANGE = Character.valueOf('o');
    private static final Character SYNCFLAG_NO_WIFI = Character.valueOf('n');
    private static final Character SYNCFIELD_SKIN = Character.valueOf('a');
    @SideOnly(value=Side.CLIENT)
    private ModelGolemWifiBackpack addonModel;
    private int wifiSyncID = -1;
    private int skinSyncID = -1;
    private ItemGolemWirelessBackpack backpackItem;
    private ItemFacade facadeItem;

    private WirelessGolemHandler() {
        if (EffectiveSide.isClientSide()) {
            this.setupModel();
        }
        this.backpackItem = (ItemGolemWirelessBackpack)ItemEnum.GOLEM_WIFI_BACKPACK.getItem();
        this.facadeItem = (ItemFacade)AEApi.instance().definitions().items().facade().maybeItem().orNull();
    }

    public static WirelessGolemHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WirelessGolemHandler();
        }
        return INSTANCE;
    }

    private Character backpackSkinToSyncChar(ItemGolemWirelessBackpack.BackpackSkins skin) {
        int id = 0;
        if (skin != null) {
            id = skin.ordinal();
        }
        return Character.valueOf((char)(SYNCFIELD_SKIN.charValue() + id));
    }

    private IGolemHookHandler.InteractionLevel canHandleInteration_Backpack(EntityGolemBase golem, Object handlerData, EntityPlayer player, Side side) {
        if (handlerData != null) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        GolemCoreType core = GolemCoreType.getCoreByID(golem.getCore());
        if (core == null) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        switch (core) {
            default: {
                return IGolemHookHandler.InteractionLevel.NoInteraction;
            }
            case Gather: 
            case Fill: 
            case Liquid: 
            case Essentia: 
        }
        if (side == Side.CLIENT) {
            player.func_71038_i();
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        return IGolemHookHandler.InteractionLevel.FullInteraction;
    }

    private IGolemHookHandler.InteractionLevel canHandleInteration_Facade(EntityGolemBase golem, Object handlerData, EntityPlayer player, Side side, ItemStack heldItem) {
        if (handlerData == null) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        ItemGolemWirelessBackpack.BackpackSkins skin = this.getSkinFromFacade(heldItem);
        if (skin == null) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        if (side == Side.CLIENT && handlerData instanceof WirelessClientData) {
            player.func_71038_i();
            ((WirelessClientData)handlerData).skin = skin;
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        return IGolemHookHandler.InteractionLevel.SyncInteraction;
    }

    private ItemGolemWirelessBackpack.BackpackSkins getSkinFromFacade(ItemStack facade) {
        Block b = this.facadeItem.getBlock(facade);
        int metaData = this.facadeItem.getMeta(facade);
        if (b == ConfigBlocks.blockCosmeticSolid) {
            if (metaData == 4) {
                return ItemGolemWirelessBackpack.BackpackSkins.Thaumium;
            }
            if (metaData == 5) {
                return ItemGolemWirelessBackpack.BackpackSkins.Tallow;
            }
        } else {
            if (b == ConfigBlocks.blockMagicalLog && metaData == 0) {
                return ItemGolemWirelessBackpack.BackpackSkins.GreatWood;
            }
            if (b == ConfigBlocks.blockTaint && metaData == 2) {
                return ItemGolemWirelessBackpack.BackpackSkins.Flesh;
            }
            if (b == Blocks.field_150348_b) {
                return ItemGolemWirelessBackpack.BackpackSkins.Stone;
            }
            if (b == Blocks.field_150407_cf) {
                return ItemGolemWirelessBackpack.BackpackSkins.Straw;
            }
            if (b == Blocks.field_150336_V) {
                return ItemGolemWirelessBackpack.BackpackSkins.Clay;
            }
            if (b == Blocks.field_150339_S) {
                return ItemGolemWirelessBackpack.BackpackSkins.Iron;
            }
            if (b == Blocks.field_150340_R) {
                return ItemGolemWirelessBackpack.BackpackSkins.Gold;
            }
            if (b == Blocks.field_150484_ah) {
                return ItemGolemWirelessBackpack.BackpackSkins.Diamond;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupModel() {
        this.addonModel = new ModelGolemWifiBackpack();
    }

    private ItemGolemWirelessBackpack.BackpackSkins syncCharToBackpackSkin(char skinSyncChar) {
        int id = skinSyncChar - SYNCFIELD_SKIN.charValue();
        if (id < 0 || id > ItemGolemWirelessBackpack.BackpackSkins.VALUES.length) {
            id = 0;
        }
        return ItemGolemWirelessBackpack.BackpackSkins.VALUES[id];
    }

    @Override
    public void addDefaultSyncEntries(IGolemHookSyncRegistry syncRegistry) {
        this.wifiSyncID = syncRegistry.registerSyncChar(this, SYNCFLAG_NO_WIFI.charValue());
        this.skinSyncID = syncRegistry.registerSyncChar(this, this.backpackSkinToSyncChar(ItemGolemWirelessBackpack.BackpackSkins.Thaumium).charValue());
    }

    @Override
    public void bellLeftClicked(EntityGolemBase golem, Object handlerData, ItemStack itemGolemPlacer, EntityPlayer player, boolean dismantled, Side side) {
        if (handlerData instanceof WirelessServerData) {
            WirelessServerData wsd = (WirelessServerData)handlerData;
            ItemStack backpack = ItemEnum.GOLEM_WIFI_BACKPACK.getStack();
            this.backpackItem.setEncryptionKey(backpack, wsd.encryptionKey, null);
            golem.func_70099_a(backpack, 0.5f);
            if (wsd.facade != null) {
                golem.func_70099_a(wsd.facade, 0.5f);
            }
        }
    }

    @Override
    public IGolemHookHandler.InteractionLevel canHandleInteraction(EntityGolemBase golem, Object handlerData, EntityPlayer player, Side side) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem == null) {
            return IGolemHookHandler.InteractionLevel.NoInteraction;
        }
        if (heldItem.func_77973_b() == this.backpackItem) {
            return this.canHandleInteration_Backpack(golem, handlerData, player, side);
        }
        if (this.facadeItem != null && heldItem.func_77973_b() == this.facadeItem) {
            return this.canHandleInteration_Facade(golem, handlerData, player, side, heldItem);
        }
        return IGolemHookHandler.InteractionLevel.NoInteraction;
    }

    @Override
    public Object customInteraction(EntityGolemBase golem, Object handlerData, IGolemHookSyncRegistry syncData, EntityPlayer player, Side side) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem.func_77973_b() == this.backpackItem) {
            String encKey = this.backpackItem.getEncryptionKey(heldItem);
            if (encKey != null) {
                golem.field_70170_p.func_72956_a((Entity)golem, "thaumcraft:upgrade", 0.5f, 1.0f);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                return new WirelessServerData(encKey);
            }
        } else if (this.facadeItem != null && heldItem.func_77973_b() == this.facadeItem) {
            WirelessServerData wsd = (WirelessServerData)handlerData;
            if (wsd.facade != null && !player.field_71075_bZ.field_75098_d) {
                golem.func_70099_a(wsd.facade, 0.5f);
            }
            wsd.facade = heldItem.func_77946_l();
            wsd.facade.field_77994_a = 1;
            if (!player.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
                if (heldItem.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            wsd.skin = this.getSkinFromFacade(wsd.facade);
            syncData.updateSyncChar(this, this.skinSyncID, this.backpackSkinToSyncChar(wsd.skin).charValue());
            golem.field_70170_p.func_72956_a((Entity)golem, "thaumcraft:cameraticks", 0.5f, 1.0f);
            return wsd;
        }
        return null;
    }

    @Override
    public void golemTick(EntityGolemBase golem, Object serverHandlerData, IGolemHookSyncRegistry syncData) {
        if (serverHandlerData instanceof WirelessServerData) {
            WirelessServerData wsd = (WirelessServerData)serverHandlerData;
            if (++wsd.tickCounter > 18) {
                wsd.tickCounter = 0;
                syncData.updateSyncChar(this, this.wifiSyncID, (wsd.isInRange ? SYNCFLAG_HAS_WIFI_IN_RANGE : SYNCFLAG_HAS_WIFI_OUT_OF_RANGE).charValue());
                syncData.updateSyncChar(this, this.skinSyncID, this.backpackSkinToSyncChar(wsd.skin).charValue());
            }
        }
    }

    @Override
    public boolean needsDynamicUpdates() {
        return true;
    }

    @Override
    public boolean needsRenderer() {
        return true;
    }

    @Override
    public Object readEntityFromNBT(EntityGolemBase golem, NBTTagCompound nbtTag) {
        WirelessServerData wsd = null;
        if (nbtTag.func_74764_b(NBTKEY_WIFI_KEY)) {
            wsd = new WirelessServerData(nbtTag.func_74779_i(NBTKEY_WIFI_KEY));
            if (nbtTag.func_74764_b(NBTKEY_FACADE)) {
                try {
                    wsd.facade = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l(NBTKEY_FACADE));
                    wsd.skin = this.getSkinFromFacade(wsd.facade);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return wsd;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGolem(EntityGolemBase golem, Object clientHandlerData, double x, double y, double z, float partialElaspsedTick) {
        boolean golemActive;
        if (!(clientHandlerData instanceof WirelessClientData)) {
            return;
        }
        WirelessClientData wcd = (WirelessClientData)clientHandlerData;
        if (golem.field_70737_aN > 0) {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (golem.healing > 0) {
            GL11.glColor3f((float)0.5f, (float)1.0f, (float)0.5f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = golemActive = wcd.isInRange && !golem.inactive;
        if (golemActive && !Minecraft.func_71410_x().func_147113_T()) {
            wcd.pearlRotation += partialElaspsedTick * 2.0f;
            if (wcd.pearlRotation >= 360.0f) {
                wcd.pearlRotation -= 360.0f;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.64f), (float)((float)z));
        float golemYaw = 270.0f;
        GL11.glRotatef((float)(golemYaw -= golem.field_70761_aq * partialElaspsedTick + golem.field_70760_ar * (1.0f - partialElaspsedTick)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.16f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.addonModel.render(wcd.pearlRotation, 0.0625f, golemActive, wcd.skin);
        GL11.glPopMatrix();
    }

    @Override
    public Object setupGolem(EntityGolemBase golem, Object handlerData, IGolemHookSyncRegistry syncData, Side side) {
        if (side == Side.CLIENT) {
            return handlerData;
        }
        if (handlerData instanceof WirelessServerData) {
            WirelessServerData wsd = (WirelessServerData)handlerData;
            GolemCoreType core = GolemCoreType.getCoreByID(golem.getCore());
            if (core != null) {
                switch (core) {
                    case Gather: {
                        golem.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIGolemWifiGather(golem, wsd));
                        break;
                    }
                    case Fill: {
                        golem.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIGolemWifiFill(golem, wsd));
                        break;
                    }
                    case Liquid: {
                        golem.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIGolemWifiLiquid(golem, wsd));
                        break;
                    }
                    case Essentia: {
                        golem.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIGolemWifiEssentia(golem, wsd));
                        break;
                    }
                }
            }
            syncData.updateSyncChar(this, this.wifiSyncID, (wsd.isInRange ? SYNCFLAG_HAS_WIFI_IN_RANGE : SYNCFLAG_HAS_WIFI_OUT_OF_RANGE).charValue());
        } else {
            syncData.updateSyncChar(this, this.wifiSyncID, SYNCFLAG_NO_WIFI.charValue());
        }
        return handlerData;
    }

    @Override
    public Object spawnGolemFromItemStack(EntityGolemBase golem, ItemStack itemGolemPlacer, Side side) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object syncDataChanged(IGolemHookSyncRegistry syncData, Object clientHandlerData) {
        boolean inRange;
        char syncFlag = syncData.getSyncCharOrDefault(this.wifiSyncID, SYNCFLAG_NO_WIFI.charValue());
        if (syncFlag == SYNCFLAG_HAS_WIFI_IN_RANGE.charValue()) {
            inRange = true;
        } else if (syncFlag == SYNCFLAG_HAS_WIFI_OUT_OF_RANGE.charValue()) {
            inRange = false;
        } else {
            return null;
        }
        WirelessClientData wcd = null;
        wcd = clientHandlerData instanceof WirelessClientData ? (WirelessClientData)clientHandlerData : new WirelessClientData();
        wcd.isInRange = inRange;
        char skinChar = syncData.getSyncCharOrDefault(this.skinSyncID, SYNCFIELD_SKIN.charValue());
        wcd.skin = this.syncCharToBackpackSkin(skinChar);
        return wcd;
    }

    @Override
    public void writeEntityNBT(EntityGolemBase golem, Object serverHandlerData, NBTTagCompound nbtTag) {
        if (serverHandlerData instanceof WirelessServerData) {
            WirelessServerData wsd = (WirelessServerData)serverHandlerData;
            nbtTag.func_74778_a(NBTKEY_WIFI_KEY, wsd.encryptionKey);
            if (wsd.facade != null) {
                nbtTag.func_74782_a(NBTKEY_FACADE, (NBTBase)wsd.facade.func_77955_b(new NBTTagCompound()));
            }
        }
    }

    public static class WirelessServerData {
        public final String encryptionKey;
        public int tickCounter = 0;
        public boolean isInRange = false;
        public ItemStack facade = null;
        public ItemGolemWirelessBackpack.BackpackSkins skin = ItemGolemWirelessBackpack.BackpackSkins.Thaumium;

        public WirelessServerData(String encKey) {
            this.encryptionKey = encKey;
        }
    }

    public static class WirelessClientData {
        public boolean isInRange = false;
        public float pearlRotation = 0.0f;
        public ItemGolemWirelessBackpack.BackpackSkins skin = ItemGolemWirelessBackpack.BackpackSkins.Thaumium;
    }
}

