/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IMaterials;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.PartItemStack;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.client.gui.GuiEssentiaIO;
import thaumicenergistics.common.container.ContainerPartEssentiaIOBus;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.IAspectSlotPart;
import thaumicenergistics.common.network.packet.client.Packet_C_AspectSlot;
import thaumicenergistics.common.network.packet.client.Packet_C_EssentiaIOBus;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.ThEPartBase;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.utils.EffectiveSide;

public abstract class ThEPartEssentiaIOBus_Base
extends ThEPartBase
implements IGridTickable,
IAspectSlotPart,
IAEAppEngInventory {
    private static final int BASE_TRANSFER_PER_SECOND = 4;
    private static final int ADDITIONAL_TRANSFER_PER_SECOND = 8;
    private static final int MINIMUM_TICKS_PER_OPERATION = 10;
    private static final int MAXIMUM_TICKS_PER_OPERATION = 40;
    private static final int MAXIMUM_TRANSFER_PER_SECOND = 64;
    private static final int MINIMUM_TRANSFER_PER_SECOND = 1;
    private static final int MAX_FILTER_SIZE = 9;
    private static final int BASE_SLOT_INDEX = 4;
    private static final int[] TIER2_INDEXS = new int[]{0, 2, 6, 8};
    private static final int[] TIER1_INDEXS = new int[]{1, 3, 5, 7};
    private static final int UPGRADE_INVENTORY_SIZE = 4;
    private static final double IDLE_POWER_DRAIN = 0.7;
    private static final RedstoneMode DEFAULT_REDSTONE_MODE = RedstoneMode.IGNORE;
    private static final String NBT_KEY_REDSTONE_MODE = "redstoneMode";
    private static final String NBT_KEY_FILTER_NUMBER = "AspectFilter#";
    private static final String NBT_KEY_UPGRADE_INV = "upgradeInventory";
    private boolean lastRedstone;
    private int[] availableFilterSlots = new int[]{4};
    private UpgradeInventory upgradeInventory = new StackUpgradeInventory(this.associatedItem, (IAEAppEngInventory)this, 4);
    private List<ContainerPartEssentiaIOBus> listeners = new ArrayList<ContainerPartEssentiaIOBus>();
    private RedstoneMode redstoneMode = DEFAULT_REDSTONE_MODE;
    protected MachineSource asMachineSource;
    protected List<Aspect> filteredAspects = new ArrayList<Aspect>(9);
    protected IAspectContainer facingContainer;
    protected byte filterSize;
    protected byte upgradeSpeedCount = 0;
    protected boolean redstoneControlled;

    public ThEPartEssentiaIOBus_Base(AEPartsEnum associatedPart, SecurityPermissions ... interactionPermissions) {
        super(associatedPart, interactionPermissions);
        for (int index = 0; index < 9; ++index) {
            this.filteredAspects.add(null);
        }
        this.asMachineSource = new MachineSource((IActionHost)this);
    }

    private boolean canDoWork() {
        boolean canWork = true;
        if (this.redstoneControlled) {
            switch (this.getRedstoneMode()) {
                case HIGH_SIGNAL: {
                    canWork = this.isReceivingRedstonePower();
                    break;
                }
                case IGNORE: {
                    break;
                }
                case LOW_SIGNAL: {
                    canWork = !this.isReceivingRedstonePower();
                    break;
                }
                case SIGNAL_PULSE: {
                    canWork = false;
                }
            }
        }
        return canWork;
    }

    private int getTransferAmountPerSecond() {
        return 4 + this.upgradeSpeedCount * 8;
    }

    private void notifyListenersOfFilterAspectChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setFilteredAspect(this.filteredAspects);
        }
    }

    private void notifyListenersOfFilterSizeChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setFilterSize(this.filterSize);
        }
    }

    private void notifyListenersOfRedstoneControlledChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setRedstoneControlled(this.redstoneControlled);
        }
    }

    private void notifyListenersOfRedstoneModeChange() {
        for (ContainerPartEssentiaIOBus listener : this.listeners) {
            listener.setRedstoneMode(this.redstoneMode);
        }
    }

    private void resizeAvailableArray() {
        this.availableFilterSlots = new int[1 + this.filterSize * 4];
        this.availableFilterSlots[0] = 4;
        if (this.filterSize < 2) {
            int i;
            for (i = 0; i < TIER2_INDEXS.length; ++i) {
                this.filteredAspects.set(TIER2_INDEXS[i], null);
            }
            if (this.filterSize < 1) {
                for (i = 0; i < TIER1_INDEXS.length; ++i) {
                    this.filteredAspects.set(TIER1_INDEXS[i], null);
                }
            } else {
                System.arraycopy(TIER1_INDEXS, 0, this.availableFilterSlots, 1, 4);
            }
        } else {
            System.arraycopy(TIER1_INDEXS, 0, this.availableFilterSlots, 1, 4);
            System.arraycopy(TIER2_INDEXS, 0, this.availableFilterSlots, 5, 4);
        }
    }

    private void updateUpgradeState() {
        byte oldFilterSize = this.filterSize;
        this.filterSize = 0;
        this.redstoneControlled = false;
        this.upgradeSpeedCount = 0;
        IMaterials aeMaterals = AEApi.instance().definitions().materials();
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = this.upgradeInventory.func_70301_a(i);
            if (slotStack == null) continue;
            if (aeMaterals.cardCapacity().isSameAs(slotStack)) {
                this.filterSize = (byte)(this.filterSize + 1);
                continue;
            }
            if (aeMaterals.cardRedstone().isSameAs(slotStack)) {
                this.redstoneControlled = true;
                continue;
            }
            if (!aeMaterals.cardSpeed().isSameAs(slotStack)) continue;
            this.upgradeSpeedCount = (byte)(this.upgradeSpeedCount + 1);
        }
        if (oldFilterSize != this.filterSize) {
            this.resizeAvailableArray();
        }
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.notifyListenersOfFilterSizeChange();
        this.notifyListenersOfRedstoneControlledChange();
    }

    public boolean addFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(itemStack);
        if (itemAspect != null) {
            if (this.filteredAspects.contains(itemAspect)) {
                return true;
            }
            for (int avalibleIndex = 0; avalibleIndex < this.availableFilterSlots.length; ++avalibleIndex) {
                int filterIndex = this.availableFilterSlots[avalibleIndex];
                if (this.filteredAspects.get(filterIndex) != null) continue;
                if (EffectiveSide.isServerSide()) {
                    this.setAspect(filterIndex, itemAspect, player);
                }
                return true;
            }
        }
        return false;
    }

    public void addListener(ContainerPartEssentiaIOBus container) {
        if (!this.listeners.contains((Object)container)) {
            this.listeners.add(container);
        }
    }

    public abstract boolean aspectTransferAllowed(Aspect var1);

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    public abstract boolean doWork(int var1);

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaIO(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            ItemStack slotStack = this.upgradeInventory.func_70301_a(slotIndex);
            if (slotStack == null || slotStack.field_77994_a <= 0) continue;
            drops.add(slotStack);
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.7;
    }

    @Override
    public int getLightLevel() {
        return this.isActive() ? 4 : 0;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaIOBus(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode arg0) {
        return new TickingRequest(10, 40, false, false);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public boolean isVoidAllowed() {
        return false;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        boolean activated = super.onActivate(player, position);
        this.updateUpgradeState();
        return activated;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.upgradeInventory) {
            this.updateUpgradeState();
        }
    }

    public void onClientRequestChangeRedstoneMode(EntityPlayer player) {
        int nextOrdinal = this.redstoneMode.ordinal() + 1;
        if (nextOrdinal >= EnumCache.AE_REDSTONE_MODES.length) {
            nextOrdinal = 0;
        }
        this.redstoneMode = EnumCache.AE_REDSTONE_MODES[nextOrdinal];
        this.notifyListenersOfRedstoneModeChange();
    }

    public void onClientRequestFilterList(EntityPlayer player) {
        Packet_C_AspectSlot.setFilterList(this.filteredAspects, player);
        Packet_C_EssentiaIOBus.sendBusState(player, this.redstoneMode, this.filterSize, this.redstoneControlled);
    }

    @Override
    public void onNeighborChanged() {
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.facingContainer = null;
        TileEntity tileEntity = this.getFacingTile();
        if (tileEntity instanceof IAspectContainer) {
            this.facingContainer = (IAspectContainer)tileEntity;
        }
        if (this.redstoneMode == RedstoneMode.SIGNAL_PULSE && this.isReceivingRedstonePower() != this.lastRedstone) {
            this.lastRedstone = this.isReceivingRedstonePower();
            this.doWork(this.getTransferAmountPerSecond());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onReceiveFilterList(List<Aspect> filteredAspects) {
        this.filteredAspects = filteredAspects;
    }

    @SideOnly(value=Side.CLIENT)
    public void onReceiveFilterSize(byte filterSize) {
        this.filterSize = filterSize;
        this.resizeAvailableArray();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_REDSTONE_MODE)) {
            this.redstoneMode = EnumCache.AE_REDSTONE_MODES[data.func_74762_e(NBT_KEY_REDSTONE_MODE)];
        }
        for (int index = 0; index < 9; ++index) {
            if (!data.func_74764_b(NBT_KEY_FILTER_NUMBER + index)) continue;
            this.filteredAspects.set(index, (Aspect)Aspect.aspects.get(data.func_74779_i(NBT_KEY_FILTER_NUMBER + index)));
        }
        if (data.func_74764_b(NBT_KEY_UPGRADE_INV)) {
            this.upgradeInventory.readFromNBT(data, NBT_KEY_UPGRADE_INV);
            this.updateUpgradeState();
        }
    }

    public void removeListener(ContainerPartEssentiaIOBus container) {
        this.listeners.remove((Object)container);
    }

    public void saveChanges() {
        this.markForSave();
    }

    @Override
    public final void setAspect(int index, Aspect aspect, EntityPlayer player) {
        this.filteredAspects.set(index, aspect);
        this.notifyListenersOfFilterAspectChange();
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.canDoWork()) {
            int transferAmountPerSecond = this.getTransferAmountPerSecond();
            int transferAmount = (int)((float)transferAmountPerSecond * ((float)ticksSinceLastCall / 20.0f));
            if (transferAmount < 1) {
                transferAmount = 1;
            } else if (transferAmount > 64) {
                transferAmount = 64;
            }
            if (this.doWork(transferAmount)) {
                return TickRateModulation.URGENT;
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType == PartItemStack.World || saveType == PartItemStack.Wrench) {
            for (int i = 0; i < 9; ++i) {
                Aspect aspect = this.filteredAspects.get(i);
                if (aspect == null) continue;
                data.func_74778_a(NBT_KEY_FILTER_NUMBER + i, aspect.getTag());
            }
            if (saveType == PartItemStack.World) {
                if (this.redstoneMode != DEFAULT_REDSTONE_MODE) {
                    data.func_74768_a(NBT_KEY_REDSTONE_MODE, this.redstoneMode.ordinal());
                }
                if (!this.upgradeInventory.isEmpty()) {
                    this.upgradeInventory.writeToNBT(data, NBT_KEY_UPGRADE_INV);
                }
            }
        }
    }
}

