/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.modintegration;

import com.rwtema.denseores.BlockDenseOre;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.modintegration.IC2Compat;
import com.rwtema.denseores.modintegration.MFRCompat;
import com.rwtema.denseores.modintegration.ModInterface;
import com.rwtema.denseores.modintegration.TE4Integration;
import com.rwtema.denseores.modintegration.ThaumcraftCompat;
import com.rwtema.denseores.modintegration.VanillaFurnace;
import cpw.mods.fml.common.registry.GameData;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ModIntegration {
    public static final String[] canonOres = new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "orePlatinum"};
    public static final String[] canonSecondaryOres = new String[]{"oreNickel", null, "oreGold", "oreIron", "oreLead", "oreSilver", "orePlatinum", null};
    public static final Random rand = new Random();
    public static ModInterface[] mods = new ModInterface[]{new VanillaFurnace(), new TE4Integration()};
    public static ModInterface[] lastMinutemods = new ModInterface[]{new ThaumcraftCompat(), new MFRCompat(), new IC2Compat()};

    public static boolean isCanonOre(String ore) {
        for (String s : canonOres) {
            if (!s.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static String getSecondCanonOre(String ore) {
        for (int i = 0; i < canonOres.length; ++i) {
            if (!canonOres[i].equals(ore)) continue;
            return canonSecondaryOres[i];
        }
        return null;
    }

    public static NBTTagCompound getItemStackNBT(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        item.func_77955_b(tag);
        return tag;
    }

    public static ItemStack cloneStack(ItemStack item, int newStackSize) {
        ItemStack newitem = item.func_77946_l();
        newitem.field_77994_a = newStackSize;
        return newitem;
    }

    public static boolean isOreSmeltsToIngot(String oreDict) {
        if ("".equals(oreDict)) {
            return false;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        return !OreDictionary.getOres((String)ingotName).isEmpty();
    }

    public static ItemStack getSmeltedIngot(String oreDict, String preferredModOwner) {
        if ("".equals(oreDict)) {
            return null;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        ItemStack out = null;
        Iterator i$ = OreDictionary.getOres((String)ingotName).iterator();
        while (i$.hasNext()) {
            ItemStack ingot;
            out = ingot = (ItemStack)i$.next();
            String s = GameData.getItemRegistry().func_148750_c((Object)ingot.func_77973_b());
            if (preferredModOwner == null || !preferredModOwner.equals(s.substring(0, s.indexOf(58)))) continue;
            return out;
        }
        return out;
    }

    public static ItemStack getFurnace(DenseOre toSmelt, float multiplier) {
        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt.newStack(1));
        if (out == null && ModIntegration.isOreSmeltsToIngot(toSmelt.baseOreDictionary)) {
            out = ModIntegration.getSmeltedIngot(toSmelt.baseOreDictionary, toSmelt.modOwner);
        }
        if (out != null) {
            out = out.func_77946_l();
            if ("minecraft:lapis_ore".equals(toSmelt.baseBlock)) {
                out.field_77994_a = 6;
            } else if ("minecraft:redstone_ore".equals(toSmelt.baseBlock)) {
                out.field_77994_a = 4;
            }
            out.field_77994_a = (int)((float)out.field_77994_a * multiplier);
            if (out.field_77994_a > 64) {
                out.field_77994_a = 64;
            } else if (out.field_77994_a < 1) {
                out.field_77994_a = 1;
            }
        }
        return out;
    }

    public static void addModIntegration() {
        ModIntegration.addModIntegration(mods);
    }

    public static void addModIntegration(ModInterface[] mods) {
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            int bId = ore.id / 16;
            int meta = ore.id % 16;
            BlockDenseOre blockDenseOre = DenseOresRegistry.blocks.get(bId);
            if (!blockDenseOre.isValid(meta)) continue;
            ItemStack output = new ItemStack(blockDenseOre.getBlock(meta), 1, ore.metadata);
            ItemStack input = new ItemStack((Block)blockDenseOre, 1, meta);
            for (ModInterface mod : mods) {
                mod.registerOre(ore, input, output);
            }
        }
    }

    public static void addLateModIntegration() {
        ModIntegration.addModIntegration(lastMinutemods);
    }

    public static boolean simpleItemStackMatch(ItemStack originalOre, ItemStack stack) {
        return stack.func_77973_b() == originalOre.func_77973_b() && stack.func_77960_j() == originalOre.func_77960_j();
    }
}

