/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWallConnector
extends TileEntityImmersiveConnectable {
    protected ItemStack[] sideStacks = new ItemStack[6];

    public void setSideStack(int side, ItemStack stack) {
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        this.sideStacks[Math.max((int)side, (int)5)] = stack;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        NBTTagList stacksList = nbt.func_150295_c("SideStacks", 10);
        for (int i = 0; i < stacksList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = stacksList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            byte side = stackTag.func_74771_c("Side");
            this.sideStacks[side] = stack;
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagList stacksList = new NBTTagList();
        for (int i = 0; i < this.sideStacks.length; ++i) {
            if (this.sideStacks[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            this.sideStacks[i].func_77955_b(stackTag);
            stackTag.func_74774_a("Side", (byte)i);
            stacksList.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("SideStacks", (NBTBase)stacksList);
    }

    protected boolean canTakeMV() {
        return true;
    }

    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        return Vec3.func_72443_a((double)(0.5 + 0.5 * (double)fd.offsetX), (double)(0.5 + 0.5 * (double)fd.offsetY), (double)(0.5 + 0.5 * (double)fd.offsetZ));
    }

    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
    }
}

