/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import latmod.lib.ByteIOStream;
import latmod.lib.LMListUtils;

public class ConfigEntryStringArray
extends ConfigEntry {
    public final List<String> defValue;
    private List<String> value = new ArrayList<String>();

    public ConfigEntryStringArray(String id, List<String> def) {
        super(id);
        this.defValue = new ArrayList<String>();
        this.set(def);
        this.defValue.addAll(def);
    }

    public ConfigEntryStringArray(String id, String ... def) {
        this(id, def == null || def.length == 0 ? new ArrayList() : Arrays.asList(def));
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.STRING_ARRAY;
    }

    @Override
    public int getColor() {
        return 16755273;
    }

    public void set(List<String> o) {
        this.value.clear();
        this.value.addAll(o);
    }

    public List<String> get() {
        return this.value;
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        this.value.clear();
        for (int i = 0; i < a.size(); ++i) {
            this.value.add(a.get(i).getAsString());
        }
        this.set(LMListUtils.clone(this.value));
    }

    @Override
    public final JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        this.value = this.get();
        for (String aValue : this.value) {
            a.add((JsonElement)new JsonPrimitive(aValue));
        }
        return a;
    }

    @Override
    public void write(ByteIOStream io) {
        this.value = this.get();
        io.writeShort(this.value.size());
        for (String aValue : this.value) {
            io.writeUTF(aValue);
        }
    }

    @Override
    public void read(ByteIOStream io) {
        this.value.clear();
        int s = io.readUnsignedShort();
        for (int i = 0; i < s; ++i) {
            this.value.add(io.readUTF());
        }
        this.set(LMListUtils.clone(this.value));
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        this.write(io);
        io.writeShort(this.defValue.size());
        for (String aDefValue : this.defValue) {
            io.writeUTF(aDefValue);
        }
    }

    @Override
    public void readExtended(ByteIOStream io) {
        this.read(io);
        this.defValue.clear();
        int s = io.readUnsignedShort();
        for (int i = 0; i < s; ++i) {
            this.defValue.add(io.readUTF());
        }
    }

    @Override
    public String getAsString() {
        return this.get().toString();
    }

    @Override
    public String[] getAsStringArray() {
        return LMListUtils.toStringArray(this.get());
    }

    @Override
    public boolean getAsBoolean() {
        return !this.get().isEmpty();
    }

    @Override
    public int[] getAsIntArray() {
        this.value = this.get();
        int[] ai = new int[this.value.size()];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = Integer.parseInt(this.value.get(i));
        }
        return ai;
    }

    @Override
    public double[] getAsDoubleArray() {
        this.value = this.get();
        double[] ai = new double[this.value.size()];
        for (int i = 0; i < ai.length; ++i) {
            ai[i] = Double.parseDouble(this.value.get(i));
        }
        return ai;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }
}

