/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class PositionedFluidTank {
    public FluidTank tank;
    public Rectangle position;
    public String overlayTexture;
    public Point overlayTexturePos;
    public boolean flowingTexture = false;
    public boolean showAmount = true;
    public boolean perTick = false;

    public PositionedFluidTank(FluidTank tank, Rectangle position, String overlayTexture, Point overlayTexturePos) {
        this.position = position;
        this.tank = tank;
        this.overlayTexture = overlayTexture;
        this.overlayTexturePos = overlayTexturePos;
    }

    public PositionedFluidTank(FluidTank tank, Rectangle position) {
        this(tank, position, null, null);
    }

    public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position, String overlayTexture, Point overlayTexturePos) {
        this(new FluidTank(fluid != null ? fluid.copy() : null, capacity), position, overlayTexture, overlayTexturePos);
    }

    public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position) {
        this(fluid, capacity, position, null, null);
    }

    public List<String> handleTooltip(List<String> currenttip) {
        if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
            return currenttip;
        }
        currenttip.add(this.tank.getFluid().getLocalizedName());
        if (this.showAmount) {
            currenttip.add(EnumChatFormatting.GRAY.toString() + this.tank.getFluid().amount + (this.perTick ? " mB/t" : " mB"));
        }
        return currenttip;
    }

    public boolean transfer(boolean usage) {
        if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
            return !(usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()}));
        }
        return false;
    }

    public void draw() {
        if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
            return;
        }
        IIcon fluidIcon = null;
        if (this.flowingTexture && this.tank.getFluid().getFluid().getFlowingIcon() != null) {
            fluidIcon = this.tank.getFluid().getFluid().getFlowingIcon();
        } else if (this.tank.getFluid().getFluid().getStillIcon() != null) {
            fluidIcon = this.tank.getFluid().getFluid().getStillIcon();
        } else {
            return;
        }
        GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
        int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GL11.glDisable((int)3042);
        int amount = Math.max(Math.min(this.position.height, this.tank.getFluid().amount * this.position.height / this.tank.getCapacity()), 1);
        int posY = this.position.y + this.position.height - amount;
        for (int i = 0; i < this.position.width; i += 16) {
            for (int j = 0; j < amount; j += 16) {
                int drawWidth = Math.min(this.position.width - i, 16);
                int drawHeight = Math.min(amount - j, 16);
                int drawX = this.position.x + i;
                int drawY = posY + j;
                double minU = fluidIcon.func_94209_e();
                double maxU = fluidIcon.func_94212_f();
                double minV = fluidIcon.func_94206_g();
                double maxV = fluidIcon.func_94210_h();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                tessellator.func_78381_a();
            }
        }
        GL11.glEnable((int)3042);
        if (this.overlayTexture != null && this.overlayTexturePos != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)this.overlayTexture);
            GuiDraw.drawTexturedModalRect((int)this.position.x, (int)this.position.y, (int)this.overlayTexturePos.x, (int)this.overlayTexturePos.y, (int)this.position.width, (int)this.position.height);
        }
    }
}

