/*
 * Decompiled with CFR 0.152.
 */
package ichun.common.core.techne.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.techne.TC2Info;
import ichun.common.core.techne.model.ModelRendererTechne;
import ichun.common.core.techne.model.components.ComponentCircularArray;
import ichun.common.core.techne.model.components.ComponentGroup;
import ichun.common.core.techne.model.components.ComponentLinearArray;
import ichun.common.core.techne.model.components.GroupModels;
import ichun.common.core.techne.model.components.ModelPart;
import ichun.common.iChunUtil;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;

@SideOnly(value=Side.CLIENT)
public class ModelTechne2
extends ModelBase {
    public ArrayList<ModelPart> modelParts = new ArrayList();

    public ModelTechne2(TC2Info info) {
        for (TC2Info.Model model : info.Techne.Models) {
            try {
                ModelPart part = new ModelPart();
                String[] scale = model.Model.GlScale.split(",");
                part.scaleX = Float.parseFloat(scale[0]);
                part.scaleY = Float.parseFloat(scale[1]);
                part.scaleZ = Float.parseFloat(scale[2]);
                String[] textureSize = model.Model.TextureSize.split(",");
                part.textureWidth = Integer.parseInt(textureSize[0]);
                part.textureHeight = Integer.parseInt(textureSize[1]);
                part.image = model.Model.image;
                this.field_78090_t = part.textureWidth;
                this.field_78089_u = part.textureHeight;
                ModelTechne2.populateGroup(this, EnumGroupType.NONE, model.Model.Geometry, part.models);
                this.modelParts.add(part);
            }
            catch (NumberFormatException e) {
                iChunUtil.console("Error parsing Techne 2 model: Invalid number", true);
                e.printStackTrace();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                iChunUtil.console("Error parsing Techne 2 model: Array too short", true);
            }
        }
    }

    public static void populateGroup(ModelBase model, EnumGroupType type, TC2Info.Group geometry, GroupModels models) {
        ComponentGroup array;
        for (TC2Info.Circular circular : geometry.Circular) {
            array = new ComponentCircularArray();
            ModelTechne2.setupComponent(model, type == EnumGroupType.NONE ? EnumGroupType.CIRCULAR : type, circular, array);
            array.count = circular.Count;
            array.radius = circular.Radius;
            models.componentCircularArray.add((ComponentCircularArray)array);
        }
        for (TC2Info.Null nullVal : geometry.Linear) {
            array = new ComponentLinearArray();
            ModelTechne2.setupComponent(model, type == EnumGroupType.NONE ? EnumGroupType.LINEAR : type, nullVal, array);
            String[] count = ((TC2Info.Linear)nullVal).Count.split(",");
            ((ComponentLinearArray)array).countX = Integer.parseInt(count[0]);
            ((ComponentLinearArray)array).countY = Integer.parseInt(count[1]);
            ((ComponentLinearArray)array).countZ = Integer.parseInt(count[2]);
            if (((ComponentLinearArray)array).countX != 0 || ((ComponentLinearArray)array).countY != 0 || ((ComponentLinearArray)array).countZ != 0) {
                if (((ComponentLinearArray)array).countX == 0) {
                    ((ComponentLinearArray)array).countX = 1;
                }
                if (((ComponentLinearArray)array).countY == 0) {
                    ((ComponentLinearArray)array).countY = 1;
                }
                if (((ComponentLinearArray)array).countZ == 0) {
                    ((ComponentLinearArray)array).countZ = 1;
                }
            }
            String[] space = ((TC2Info.Linear)nullVal).Spacing.split(",");
            ((ComponentLinearArray)array).spaceX = Float.parseFloat(space[0]);
            ((ComponentLinearArray)array).spaceY = Float.parseFloat(space[1]);
            ((ComponentLinearArray)array).spaceZ = Float.parseFloat(space[2]);
            models.componentLinearArray.add((ComponentLinearArray)array);
        }
        for (TC2Info.Null nullVal : geometry.Null) {
            array = new ComponentGroup();
            ModelTechne2.setupComponent(model, type, nullVal, array);
            models.componentGroup.add(array);
        }
        for (TC2Info.Shape shape : geometry.Shape) {
            String[] textureOffset = shape.TextureOffset.split(",");
            ModelRendererTechne cube = new ModelRendererTechne(model, shape.Name);
            cube.func_78784_a(Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
            cube.field_78809_i = !shape.IsMirrored.equals("False");
            String[] pos = shape.Position.split(",");
            String[] rot = shape.Rotation.split(",");
            String[] size = shape.Size.split(",");
            String[] offset = new String[]{"0", "0", "0"};
            if (shape.Offset != null) {
                offset = shape.Offset.split(",");
            } else if (type == EnumGroupType.CIRCULAR) {
                offset = new String[]{Float.toString(Float.parseFloat(size[0]) / -2.0f), Float.toString(Float.parseFloat(size[1]) / -2.0f), Float.toString(Float.parseFloat(size[2]) / -2.0f)};
                rot = new String[]{"0", "0", "0"};
                pos = rot;
            }
            cube.func_78789_a(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
            cube.func_78793_a(Float.parseFloat(pos[0]), Float.parseFloat(pos[1]), Float.parseFloat(pos[2]));
            cube.field_78795_f = Float.parseFloat(rot[0]);
            cube.field_78796_g = Float.parseFloat(rot[1]);
            cube.field_78808_h = Float.parseFloat(rot[2]);
            models.models.add(cube);
        }
    }

    public static void setupComponent(ModelBase model, EnumGroupType type, TC2Info.Null info, ComponentGroup component) {
        String[] pos = info.Position.split(",");
        component.posX = Float.parseFloat(pos[0]);
        component.posY = Float.parseFloat(pos[1]);
        component.posZ = Float.parseFloat(pos[2]);
        String[] rot = info.Rotation.split(",");
        component.rotationX = Float.parseFloat(rot[0]);
        component.rotationY = Float.parseFloat(rot[1]);
        component.rotationZ = Float.parseFloat(rot[2]);
        ModelTechne2.populateGroup(model, type, info.Children, component.groupModels);
    }

    public void render(boolean bindTexture, float f5) {
        for (int i = this.modelParts.size() - 1; i >= 0; --i) {
            ModelPart modelPart = this.modelParts.get(i);
            if (modelPart.render(bindTexture, f5)) continue;
            this.modelParts.remove(i);
        }
    }

    public static enum EnumGroupType {
        NONE,
        CIRCULAR,
        LINEAR;

    }
}

