/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.gui.client;

import cofh.lib.gui.GuiBase;
import cofh.lib.render.RenderHelper;
import io.endertech.tile.TileET;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiETBase
extends GuiBase {
    public TileET tileET;

    public GuiETBase(Container container, ResourceLocation texture, TileET tileET) {
        super(container, texture);
        this.tileET = tileET;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.tileET.hasGui()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void drawFluidWithOpacity(int x, int y, FluidStack fluid, int width, int height, float opacity) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.setBlockTextureSheet();
        this.drawTiledTextureWithColour(x, y, fluid.getFluid().getIcon(fluid), width, height, fluid.getFluid().getColor(fluid), opacity);
        GL11.glPopMatrix();
    }

    public void drawTiledTextureWithColour(int x, int y, IIcon icon, int width, int height, int colour, float opacity) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIconWithColour(x + i, y + j, icon, drawWidth, drawHeight, colour, opacity);
            }
        }
    }

    public void drawScaledTexturedModelRectFromIconWithColour(int x, int y, IIcon icon, int width, int height, int colour, float opacity) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        tessellator.func_78369_a(r, g, b, opacity);
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
    }
}

