/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.TileEntityIronChest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum PacketHandler {
    INSTANCE;

    private EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("IronChest", new ChannelHandler[]{new IronChestCodec()});

    private PacketHandler() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addClientHandler();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addClientHandler() {
        FMLEmbeddedChannel clientChannel = this.channels.get(Side.CLIENT);
        String codec = clientChannel.findChannelHandlerNameForType(IronChestCodec.class);
        clientChannel.pipeline().addAfter(codec, "ClientHandler", (ChannelHandler)new IronChestMessageHandler());
    }

    public static Packet getPacket(TileEntityIronChest tileEntityIronChest) {
        IronChestMessage msg = new IronChestMessage();
        msg.x = tileEntityIronChest.field_145851_c;
        msg.y = tileEntityIronChest.field_145848_d;
        msg.z = tileEntityIronChest.field_145849_e;
        msg.type = tileEntityIronChest.getType().ordinal();
        msg.facing = tileEntityIronChest.getFacing();
        msg.itemStacks = tileEntityIronChest.buildItemStackDataList();
        return PacketHandler.INSTANCE.channels.get(Side.SERVER).generatePacketFrom((Object)msg);
    }

    private class IronChestCodec
    extends FMLIndexedMessageToMessageCodec<IronChestMessage> {
        public IronChestCodec() {
            this.addDiscriminator(0, IronChestMessage.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, IronChestMessage msg, ByteBuf target) throws Exception {
            target.writeInt(msg.x);
            target.writeInt(msg.y);
            target.writeInt(msg.z);
            int typeAndFacing = (msg.type & 0xF | (msg.facing & 0xF) << 4) & 0xFF;
            target.writeByte(typeAndFacing);
            target.writeBoolean(msg.itemStacks != null);
            if (msg.itemStacks != null) {
                for (ItemStack i : msg.itemStacks) {
                    ByteBufUtils.writeItemStack((ByteBuf)target, (ItemStack)i);
                }
            }
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IronChestMessage msg) {
            msg.x = dat.readInt();
            msg.y = dat.readInt();
            msg.z = dat.readInt();
            byte typDat = dat.readByte();
            msg.type = (byte)(typDat & 0xF);
            msg.facing = (byte)(typDat >> 4 & 0xF);
            boolean hasStacks = dat.readBoolean();
            msg.itemStacks = new ItemStack[0];
            if (hasStacks) {
                msg.itemStacks = new ItemStack[8];
                for (int i = 0; i < msg.itemStacks.length; ++i) {
                    msg.itemStacks[i] = ByteBufUtils.readItemStack((ByteBuf)dat);
                }
            }
        }
    }

    public static class IronChestMessage {
        int x;
        int y;
        int z;
        int type;
        int facing;
        ItemStack[] itemStacks;
    }

    private static class IronChestMessageHandler
    extends SimpleChannelInboundHandler<IronChestMessage> {
        private IronChestMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, IronChestMessage msg) throws Exception {
            World world = IronChest.proxy.getClientWorld();
            TileEntity te = world.func_147438_o(msg.x, msg.y, msg.z);
            if (te instanceof TileEntityIronChest) {
                TileEntityIronChest icte = (TileEntityIronChest)te;
                icte.setFacing(msg.facing);
                icte.handlePacketData(msg.type, msg.itemStacks);
            }
        }
    }
}

