/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.events.ValueEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerContainer;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.teleporter.PacketGetPlayers;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEnvironmentalController
extends GenericGuiContainer<EnvironmentalControllerTileEntity> {
    public static final int ENV_WIDTH = 194;
    public static final int ENV_HEIGHT = 224;
    public static final String MODE_BLACKLIST = "BL";
    public static final String MODE_WHITELIST = "WL";
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/environmentalcontroller.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private List<String> players = null;
    private int listDirty = 0;
    private static Set<String> fromServer_players = new HashSet<String>();
    private Panel toplevel;
    private TextField minyTextField;
    private TextField maxyTextField;
    private TextField nameField;
    private ImageChoiceLabel redstoneMode;
    private WidgetList playersList;
    private Button addButton;
    private Button delButton;

    public static void storePlayersForClient(List<PlayerName> players) {
        HashSet<String> p = new HashSet<String>();
        for (PlayerName n : players) {
            p.add(n.getName());
        }
        fromServer_players = p;
    }

    public GuiEnvironmentalController(EnvironmentalControllerTileEntity environmentalControllerTileEntity, EnvironmentalControllerContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)environmentalControllerTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "envctrl");
        this.field_146999_f = 194;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int r = ((EnvironmentalControllerTileEntity)this.tileEntity).getRadius();
        if (r < 5) {
            r = 5;
        } else if (r > 100) {
            r = 100;
        }
        int miny = ((EnvironmentalControllerTileEntity)this.tileEntity).getMiny();
        int maxy = ((EnvironmentalControllerTileEntity)this.tileEntity).getMaxy();
        Panel radiusPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25, 6, 164, 16));
        ScrollableLabel radius = ((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setRealMinimum(5).setRealMaximum(100).setRealValue(r).setDesiredWidth(24)).addValueEvent(new ValueEvent(){

            public void valueChanged(Widget parent, int newValue) {
                GuiEnvironmentalController.this.sendServerCommand(RFToolsMessages.INSTANCE, "setRadius", new Argument[]{new Argument("radius", newValue)});
            }
        });
        Slider slider = new Slider(this.field_146297_k, (Gui)this).setHorizontal().setScrollable((Scrollable)radius).setMinimumKnobSize(12);
        ((Panel)((Panel)radiusPanel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Radius:"))).addChild((Widget)slider)).addChild((Widget)radius);
        Panel minPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25, 24, 164, 16));
        this.minyTextField = new TextField(this.field_146297_k, (Gui)this).setText(Integer.toString(miny)).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiEnvironmentalController.this.sendBounds(true);
            }
        });
        this.maxyTextField = new TextField(this.field_146297_k, (Gui)this).setText(Integer.toString(maxy)).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiEnvironmentalController.this.sendBounds(false);
            }
        });
        ((Panel)((Panel)minPanel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Height:"))).addChild((Widget)this.minyTextField)).addChild((Widget)this.maxyTextField);
        this.playersList = new WidgetList(this.field_146297_k, (Gui)this);
        Slider playerSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(11)).setVertical().setScrollable((Scrollable)this.playersList);
        Panel playersPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25, 42, 164, 72))).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.playersList)).addChild((Widget)playerSlider);
        Panel controlPanel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25, 118, 164, 16))).setLayout((Layout)((HorizontalLayout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(1)).setVerticalMargin(0)).setSpacing(1));
        ChoiceLabel blacklist = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{MODE_BLACKLIST, MODE_WHITELIST}).setDesiredWidth(30)).setDesiredHeight(15)).setChoiceTooltip(MODE_BLACKLIST, new String[]{"Players in the list above will not get the effects"}).setChoiceTooltip(MODE_WHITELIST, new String[]{"Players in the list above will get the effects"}).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiEnvironmentalController.this.changeBlacklistMode(newChoice);
            }
        });
        if (((EnvironmentalControllerTileEntity)this.tileEntity).isWhitelistMode()) {
            blacklist.setChoice(MODE_WHITELIST);
        } else {
            blacklist.setChoice(MODE_BLACKLIST);
        }
        this.addButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("+")).setDesiredHeight(15)).setTooltips(new String[]{"Add a player to the list"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiEnvironmentalController.this.addPlayer();
            }
        });
        this.delButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("-")).setDesiredHeight(15)).setTooltips(new String[]{"Remove selected player from the list"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiEnvironmentalController.this.delPlayer();
            }
        });
        this.nameField = new TextField(this.field_146297_k, (Gui)this);
        this.initRedstoneMode();
        ((Panel)((Panel)((Panel)((Panel)controlPanel.addChild((Widget)blacklist)).addChild((Widget)this.addButton)).addChild((Widget)this.delButton)).addChild((Widget)this.nameField)).addChild((Widget)this.redstoneMode);
        ((Panel)((Panel)((Panel)this.toplevel.addChild((Widget)radiusPanel)).addChild((Widget)minPanel)).addChild((Widget)playersPanel)).addChild((Widget)controlPanel);
        this.toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)this.toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        this.listDirty = 0;
        this.requestPlayers();
    }

    private void initRedstoneMode() {
        this.redstoneMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setDesiredHeight(16)).setDesiredWidth(16)).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiEnvironmentalController.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setCurrentChoice(((EnvironmentalControllerTileEntity)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeBlacklistMode(String newAccess) {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setBlacklist", new Argument[]{new Argument("blacklist", MODE_BLACKLIST.equals(newAccess))});
    }

    private void changeRedstoneMode() {
        ((EnvironmentalControllerTileEntity)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "rsMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    private void addPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "addPlayer", new Argument[]{new Argument("player", this.nameField.getText())});
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "delPlayer", new Argument[]{new Argument("player", this.players.get(this.playersList.getSelected()))});
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetPlayers(((EnvironmentalControllerTileEntity)this.tileEntity).field_145851_c, ((EnvironmentalControllerTileEntity)this.tileEntity).field_145848_d, ((EnvironmentalControllerTileEntity)this.tileEntity).field_145849_e, "getPlayers", "getPlayers"));
    }

    private void populatePlayers() {
        ArrayList<String> newPlayers = new ArrayList<String>(fromServer_players);
        Collections.sort(newPlayers);
        if (newPlayers.equals(this.playersList)) {
            return;
        }
        this.players = new ArrayList<String>(newPlayers);
        this.playersList.removeChildren();
        for (String player : this.players) {
            this.playersList.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(player).setColor(StyleConfig.colorTextInListNormal).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    private void sendBounds(boolean minchanged) {
        int maxy;
        int miny;
        try {
            miny = Integer.parseInt(this.minyTextField.getText());
        }
        catch (NumberFormatException e) {
            miny = 0;
        }
        try {
            maxy = Integer.parseInt(this.maxyTextField.getText());
        }
        catch (NumberFormatException e) {
            maxy = 0;
        }
        if (minchanged) {
            if (miny > maxy) {
                maxy = miny;
                this.maxyTextField.setText(Integer.toString(maxy));
            }
        } else if (miny > maxy) {
            miny = maxy;
            this.minyTextField.setText(Integer.toString(miny));
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setBounds", new Argument[]{new Argument("miny", miny), new Argument("maxy", maxy)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.drawWindow();
    }

    private void enableButtons() {
        int isPlayerSelected = this.playersList.getSelected();
        this.delButton.setEnabled(isPlayerSelected != -1);
        String name = this.nameField.getText();
        this.addButton.setEnabled(name != null && !name.isEmpty());
    }
}

