/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class KnownDimlet
extends Item {
    private final Map<DimletType, IIcon> icons = new HashMap<DimletType, IIcon>();

    public KnownDimlet() {
        this.func_77625_d(DimletConfiguration.dimletStackSize);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (DimletType type : DimletType.values()) {
            IIcon icon = iconRegister.func_94245_a("rftools:dimlets/" + type.dimletType.getTextureName());
            this.icons.put(type, icon);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(stack, world);
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry != null && this.isSeedDimlet(entry)) {
            boolean locked;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            if (locked = tagCompound.func_74767_n("locked")) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "This seed dimlet is locked. You cannot modify it!"));
                return stack;
            }
            long forcedSeed = tagCompound.func_74763_f("forcedSeed");
            if (player.func_70093_af()) {
                if (forcedSeed == 0L) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "This dimlet has no seed. You cannot lock it!"));
                    return stack;
                }
                tagCompound.func_74757_a("locked", true);
                Logging.message((EntityPlayer)player, (String)"Dimlet locked!");
            } else {
                long seed = world.func_72905_C();
                tagCompound.func_74772_a("forcedSeed", seed);
                Logging.message((EntityPlayer)player, (String)("Seed set to: " + seed));
            }
            stack.func_77982_d(tagCompound);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        DimletKey key = KnownDimletConfiguration.getDimletKey(itemStack, player.func_130014_f_());
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry == null) {
            if (KnownDimletConfiguration.isBlacklisted(key)) {
                list.add(EnumChatFormatting.WHITE + "Dimlet " + key.getType().dimletType.getName() + "." + key.getName());
                list.add(EnumChatFormatting.RED + "This dimlet is blacklisted!");
            } else {
                list.add(EnumChatFormatting.RED + "Something is wrong!");
                list.add(EnumChatFormatting.RED + "Dimlet with key " + key + " (id " + itemStack.func_77960_j() + ") is missing!");
            }
            return;
        }
        list.add(EnumChatFormatting.BLUE + "Rarity: " + entry.getRarity() + (KnownDimletConfiguration.craftableDimlets.contains(key) ? " (craftable)" : ""));
        list.add(EnumChatFormatting.YELLOW + "Create cost: " + entry.getRfCreateCost() + " RF/tick");
        int maintainCost = entry.getRfMaintainCost();
        if (maintainCost < 0) {
            list.add(EnumChatFormatting.YELLOW + "Maintain cost: " + maintainCost + "% RF/tick");
        } else {
            list.add(EnumChatFormatting.YELLOW + "Maintain cost: " + maintainCost + " RF/tick");
        }
        list.add(EnumChatFormatting.YELLOW + "Tick cost: " + entry.getTickCost() + " ticks");
        if (this.isSeedDimlet(entry)) {
            String[] tagCompound = itemStack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74763_f("forcedSeed") != 0L) {
                long forcedSeed = tagCompound.func_74763_f("forcedSeed");
                boolean locked = tagCompound.func_74767_n("locked");
                list.add(EnumChatFormatting.BLUE + "Forced seed: " + forcedSeed + (locked ? " [LOCKED]" : ""));
            } else {
                list.add(EnumChatFormatting.BLUE + "Right click to copy seed from dimension.");
                list.add(EnumChatFormatting.BLUE + "Shift-Right click to lock copied seed.");
            }
        }
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            list.add(EnumChatFormatting.AQUA + "Dimlet key: " + key);
            if (KnownDimletConfiguration.isNewKnownDimlet(itemStack)) {
                list.add(EnumChatFormatting.AQUA + "This dimlet uses a new key");
            } else {
                list.add(EnumChatFormatting.AQUA + "This dimlet uses an old key");
            }
        } else if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            for (String info : entry.getKey().getType().dimletType.getInformation()) {
                list.add(EnumChatFormatting.WHITE + info);
            }
            List<String> extra = KnownDimletConfiguration.idToExtraInformation.get(entry.getKey());
            if (extra != null) {
                for (String info : extra) {
                    list.add(EnumChatFormatting.YELLOW + info);
                }
            }
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    private boolean isSeedDimlet(DimletEntry entry) {
        return entry.getKey().getType() == DimletType.DIMLET_SPECIAL && "Seed".equals(entry.getKey().getName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(stack, null);
        if (key == null) {
            return this.icons.get((Object)DimletType.DIMLET_SPECIAL);
        }
        DimletType type = key.getType();
        return this.icons.get((Object)type);
    }

    public String func_77667_c(ItemStack itemStack) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(itemStack, null);
        String name = KnownDimletConfiguration.idToDisplayName.get(key);
        if (name == null) {
            return "<unknown dimlet>";
        }
        return name;
    }

    public String func_77653_i(ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        DimletMapping mapping = DimletMapping.getInstance();
        if (mapping != null) {
            ArrayList<DimletKey> sortedKeys = new ArrayList<DimletKey>(mapping.getKeys());
            Collections.sort(sortedKeys, new Comparator<DimletKey>(){

                @Override
                public int compare(DimletKey o1, DimletKey o2) {
                    if (o1.getType() == o2.getType()) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return o1.getType().compareTo(o2.getType());
                }
            });
            for (DimletKey key : sortedKeys) {
                list.add(KnownDimletConfiguration.makeKnownDimlet(key, null));
            }
        }
    }
}

