/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.playerprops.PacketSendBuffsToClient;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class BuffProperties {
    public static final int BUFF_MAXTICKS = 180;
    private int buffTimeout = 0;
    private final Map<PlayerBuff, Integer> buffs = new HashMap<PlayerBuff, Integer>();
    private boolean oldAllowFlying = false;
    private boolean allowFlying = false;
    private Entity entity = null;
    private boolean globalSyncNeeded = true;

    public void setEntity(Entity entity) {
        this.entity = entity;
        this.globalSyncNeeded = true;
    }

    private void syncBuffs() {
        RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSendBuffsToClient(this.buffs), (EntityPlayerMP)this.entity);
    }

    public void tickBuffs() {
        --this.buffTimeout;
        if (this.buffTimeout <= 0) {
            this.buffTimeout = 180;
            HashMap<PlayerBuff, Integer> copyBuffs = new HashMap<PlayerBuff, Integer>(this.buffs);
            this.buffs.clear();
            boolean syncNeeded = false;
            for (Map.Entry entry : copyBuffs.entrySet()) {
                int timeout = (Integer)entry.getValue();
                if ((timeout -= 180) > 0) {
                    this.buffs.put((PlayerBuff)((Object)entry.getKey()), timeout);
                    continue;
                }
                syncNeeded = true;
            }
            if (syncNeeded) {
                this.syncBuffs();
                this.performBuffs();
                this.globalSyncNeeded = false;
            }
        }
        if (this.globalSyncNeeded) {
            this.globalSyncNeeded = false;
            this.syncBuffs();
            this.performBuffs();
        }
    }

    private void performBuffs() {
        EntityPlayer player = (EntityPlayer)this.entity;
        boolean enableFlight = false;
        for (PlayerBuff buff : this.buffs.keySet()) {
            if (buff != PlayerBuff.BUFF_FLIGHT) continue;
            enableFlight = true;
            break;
        }
        boolean oldAllow = player.field_71075_bZ.field_75101_c;
        if (enableFlight) {
            if (!this.allowFlying) {
                this.oldAllowFlying = player.field_71075_bZ.field_75101_c;
                this.allowFlying = true;
            }
            player.field_71075_bZ.field_75101_c = true;
        } else if (this.allowFlying) {
            player.field_71075_bZ.field_75101_c = this.oldAllowFlying;
            if (player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = true;
            }
            this.allowFlying = false;
        }
        if (player.field_71075_bZ.field_75101_c != oldAllow && !player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75100_b = false;
        }
        player.func_71016_p();
    }

    public static void addBuff(EntityPlayer player, PlayerBuff buff, int ticks) {
        PlayerExtendedProperties playerExtendedProperties = PlayerExtendedProperties.getProperties(player);
        playerExtendedProperties.getBuffProperties().addBuff(buff, ticks);
    }

    public void addBuff(PlayerBuff buff, int ticks) {
        this.buffs.put(buff, ticks + 5);
        this.syncBuffs();
        this.performBuffs();
    }

    public Map<PlayerBuff, Integer> getBuffs() {
        return this.buffs;
    }

    public boolean hasBuff(PlayerBuff buff) {
        return this.buffs.containsKey((Object)buff);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("buffTicks", this.buffTimeout);
        compound.func_74757_a("allowFlying", this.allowFlying);
        compound.func_74757_a("oldAllowFlying", this.oldAllowFlying);
        int[] buffArray = new int[this.buffs.size()];
        int[] timeoutArray = new int[this.buffs.size()];
        int idx = 0;
        for (Map.Entry<PlayerBuff, Integer> entry : this.buffs.entrySet()) {
            PlayerBuff buff = entry.getKey();
            buffArray[idx] = buff.ordinal();
            timeoutArray[idx] = entry.getValue();
            ++idx;
        }
        compound.func_74783_a("buffs", buffArray);
        compound.func_74783_a("buffTimeouts", timeoutArray);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.buffTimeout = compound.func_74762_e("buffTicks");
        int[] buffArray = compound.func_74759_k("buffs");
        int[] timeoutArray = compound.func_74759_k("buffTimeouts");
        this.buffs.clear();
        for (int i = 0; i < buffArray.length; ++i) {
            int buffIdx = buffArray[i];
            this.buffs.put(PlayerBuff.values()[buffIdx], timeoutArray[i]);
        }
        this.allowFlying = compound.func_74767_n("allowFlying");
        this.oldAllowFlying = compound.func_74767_n("oldAllowFlying");
        this.globalSyncNeeded = true;
    }
}

