/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.EnvironmentGlobal;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.definitions.ParsedFunction;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.statements.StatementReturn;
import stanhebben.zenscript.symbols.SymbolArgument;
import stanhebben.zenscript.symbols.SymbolZenStaticMethod;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenModule {
    private final Map<String, byte[]> classes;
    private final MyClassLoader classLoader;

    public static void compileScripts(String mainFileName, List<ZenParsedFile> scripts, IEnvironmentGlobal environmentGlobal, boolean debug) {
        ClassWriter clsMain = new ClassWriter(2);
        clsMain.visitSource(mainFileName, null);
        clsMain.visit(50, 1, "__ZenMain__", null, ZenTypeUtil.internal(Object.class), new String[]{ZenTypeUtil.internal(Runnable.class)});
        MethodOutput mainRun = new MethodOutput((ClassVisitor)clsMain, 1, "run", "()V", null, null);
        mainRun.start();
        for (ZenParsedFile script : scripts) {
            for (Map.Entry<String, ParsedFunction> function : script.getFunctions().entrySet()) {
                ParsedFunction fn = function.getValue();
                environmentGlobal.putValue(function.getKey(), new SymbolZenStaticMethod(script.getClassName(), fn.getName(), fn.getSignature(), fn.getArgumentTypes(), fn.getReturnType()), fn.getPosition());
            }
        }
        for (ZenParsedFile script : scripts) {
            ClassWriter clsScript = new ClassWriter(2);
            clsScript.visitSource(script.getFileName(), null);
            EnvironmentClass environmentScript = new EnvironmentClass((ClassVisitor)clsScript, script.getEnvironment());
            clsScript.visit(50, 1, script.getClassName().replace('.', '/'), null, ZenTypeUtil.internal(Object.class), new String[]{ZenTypeUtil.internal(Runnable.class)});
            for (Map.Entry entry : script.getFunctions().entrySet()) {
                Statement[] statements;
                ParsedFunction fn = (ParsedFunction)entry.getValue();
                String signature = fn.getSignature();
                MethodOutput methodOutput = new MethodOutput((ClassVisitor)clsScript, 9, (String)entry.getKey(), signature, null, null);
                EnvironmentMethod methodEnvironment = new EnvironmentMethod(methodOutput, environmentScript);
                List<ParsedFunctionArgument> arguments = ((ParsedFunction)entry.getValue()).getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    ParsedFunctionArgument argument = arguments.get(i);
                    methodEnvironment.putValue(argument.getName(), new SymbolArgument(i, argument.getType()), fn.getPosition());
                }
                methodOutput.start();
                for (Statement statement : statements = fn.getStatements()) {
                    statement.compile(methodEnvironment);
                }
                if (((ParsedFunction)entry.getValue()).getReturnType() != ZenType.VOID) {
                    if (statements[statements.length - 1] instanceof StatementReturn) {
                        if (((StatementReturn)statements[statements.length - 1]).getExpression() != null) {
                            fn.getReturnType().defaultValue(fn.getPosition()).compile(true, methodEnvironment);
                            methodOutput.returnType(fn.getReturnType().toASMType());
                        }
                    } else {
                        fn.getReturnType().defaultValue(fn.getPosition()).compile(true, methodEnvironment);
                        methodOutput.returnType(fn.getReturnType().toASMType());
                    }
                }
                methodOutput.end();
            }
            if (script.getStatements().size() > 0) {
                MethodOutput scriptOutput = new MethodOutput((ClassVisitor)clsScript, 9, "__script__", "()V", null, null);
                EnvironmentMethod environmentMethod = new EnvironmentMethod(scriptOutput, environmentScript);
                scriptOutput.start();
                for (Statement statement : script.getStatements()) {
                    statement.compile(environmentMethod);
                }
                scriptOutput.ret();
                scriptOutput.end();
                mainRun.invokeStatic(script.getClassName().replace('.', '/'), "__script__", "()V");
            }
            clsScript.visitEnd();
            environmentGlobal.putClass(script.getClassName(), clsScript.toByteArray());
        }
        mainRun.ret();
        mainRun.end();
        clsMain.visitEnd();
        MethodVisitor constructor = clsMain.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        if (debug) {
            try {
                File outputDir = new File("generated");
                outputDir.mkdir();
                for (String className : environmentGlobal.getClassNames()) {
                    File outputFile = new File(outputDir, className.replace('.', '/') + ".class");
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                    fileOutputStream.write(environmentGlobal.getClass(className));
                    fileOutputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        environmentGlobal.putClass("__ZenMain__", clsMain.toByteArray());
    }

    public static ZenModule compileScriptFile(File single, IZenCompileEnvironment environment, ClassLoader baseClassLoader) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassNameGenerator nameGen = new ClassNameGenerator();
        EnvironmentGlobal environmentGlobal = new EnvironmentGlobal(environment, classes, nameGen);
        String filename = single.getName();
        String className = ZenModule.extractClassName(filename);
        FileInputStream input = new FileInputStream(single);
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(input));
        ZenTokener parser = new ZenTokener((Reader)reader, environment);
        ZenParsedFile file = new ZenParsedFile(filename, className, parser, environmentGlobal);
        ((Reader)reader).close();
        ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
        files.add(file);
        ZenModule.compileScripts(filename, files, environmentGlobal, false);
        File outputDir = new File("generated");
        outputDir.mkdir();
        for (Map.Entry entry : classes.entrySet()) {
            File outputFile = new File(outputDir, ((String)entry.getKey()).replace('.', '/') + ".class");
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            FileOutputStream output = new FileOutputStream(outputFile);
            output.write((byte[])entry.getValue());
            output.close();
        }
        return new ZenModule(classes, baseClassLoader);
    }

    public static ZenModule compileZip(File file, String subdir, IZenCompileEnvironment environment, ClassLoader baseClassLoader) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassNameGenerator nameGen = new ClassNameGenerator();
        EnvironmentGlobal environmentGlobal = new EnvironmentGlobal(environment, classes, nameGen);
        ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(subdir) || entry.getName().equals(subdir)) continue;
            String filename = entry.getName().substring(subdir.length());
            String className = ZenModule.extractClassName(filename);
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(zipFile.getInputStream(entry)));
            ZenTokener parser = new ZenTokener((Reader)reader, environment);
            ZenParsedFile pfile = new ZenParsedFile(filename, className, parser, environmentGlobal);
            files.add(pfile);
            ((Reader)reader).close();
        }
        String filename = file.getName();
        ZenModule.compileScripts(filename, files, environmentGlobal, true);
        return new ZenModule(classes, baseClassLoader);
    }

    public ZenModule(Map<String, byte[]> classes, ClassLoader baseClassLoader) {
        this.classes = classes;
        this.classLoader = new MyClassLoader(baseClassLoader);
    }

    public Runnable getMain() {
        try {
            return (Runnable)this.classLoader.loadClass("__ZenMain__").newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static String extractClassName(String filename) {
        if ((filename = filename.replace('\\', '/')).startsWith("/")) {
            filename = filename.substring(1);
        }
        int lastSlash = filename.lastIndexOf(47);
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > lastSlash) {
            filename = filename.substring(0, lastDot);
        }
        if (lastSlash > 0) {
            String dir = filename.substring(0, lastSlash);
            String name = filename.substring(lastSlash + 1, lastSlash + 2).toUpperCase() + filename.substring(lastSlash + 2);
            return dir + '.' + name;
        }
        return filename.substring(0, 1).toUpperCase() + filename.substring(1);
    }

    private class MyClassLoader
    extends ClassLoader {
        private MyClassLoader(ClassLoader baseClassLoader) {
            super(baseClassLoader);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (ZenModule.this.classes.containsKey(name)) {
                return this.defineClass(name, (byte[])ZenModule.this.classes.get(name), 0, ((byte[])ZenModule.this.classes.get(name)).length);
            }
            return super.findClass(name);
        }
    }
}

