/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import openmods.calc.BinaryOperator;
import openmods.calc.Operator;
import openmods.calc.OperatorDictionary;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IExprNodeFactory;
import openmods.calc.parsing.IModifierStateTransition;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.InvalidTokenException;
import openmods.calc.parsing.NonExpressionException;
import openmods.calc.parsing.Token;
import openmods.calc.parsing.TokenType;
import openmods.calc.parsing.TokenUtils;
import openmods.calc.parsing.UnfinishedExpressionException;
import openmods.calc.parsing.UnmatchedBracketsException;
import openmods.utils.Stack;

public class InfixParser<E>
implements IAstParser<E> {
    private static final String CALL_OPENING_BRACKET = "(";
    private final OperatorDictionary<E> operators;
    private IExprNodeFactory<E> exprNodeFactory;

    public InfixParser(OperatorDictionary<E> operators, IExprNodeFactory<E> exprNodeFactory) {
        this.exprNodeFactory = exprNodeFactory;
        this.operators = operators;
    }

    private static Token next(Iterator<Token> input) {
        try {
            return input.next();
        }
        catch (NoSuchElementException e) {
            throw new UnfinishedExpressionException();
        }
    }

    @Override
    public IExprNode<E> parse(ICompilerState<E> state, PeekingIterator<Token> input) {
        Stack<IExprNode<IExprNode<E>>> nodeStack = Stack.create();
        Stack<Operator<E>> operatorStack = Stack.create();
        BinaryOperator<E> defaultOperator = this.operators.getDefaultOperator();
        boolean pushedNonOperatorLastLoop = false;
        while (input.hasNext()) {
            Token token = (Token)input.peek();
            boolean pushedNonOperatorThisLoop = true;
            if (token.type.isExpressionTerminator()) break;
            InfixParser.next(input);
            if (token.type.isValue()) {
                nodeStack.push(this.exprNodeFactory.createValueNode(token));
            } else if (token.type.isSymbol()) {
                Preconditions.checkArgument((token.type != TokenType.SYMBOL_WITH_ARGS ? 1 : 0) != 0, (String)"Symbol '%s' can't be used in infix mode", (Object[])new Object[]{token.value});
                if (input.hasNext()) {
                    Token nextToken = (Token)input.peek();
                    if (nextToken.type == TokenType.LEFT_BRACKET && nextToken.value.equals(CALL_OPENING_BRACKET)) {
                        input.next();
                        String openingBracket = nextToken.value;
                        String closingBracket = TokenUtils.getClosingBracket(openingBracket);
                        ISymbolCallStateTransition<E> stateTransition = state.getStateForSymbolCall(token.value);
                        List<IExprNode<E>> childrenNodes = this.collectChildren(input, openingBracket, closingBracket, stateTransition.getState());
                        nodeStack.push(stateTransition.createRootNode(childrenNodes));
                    } else {
                        nodeStack.push(this.exprNodeFactory.createSymbolGetNode(token.value));
                    }
                } else {
                    nodeStack.push(this.exprNodeFactory.createSymbolGetNode(token.value));
                }
            } else if (token.type == TokenType.MODIFIER) {
                IModifierStateTransition<E> stateTransition = state.getStateForModifier(token.value);
                ICompilerState<E> newState = stateTransition.getState();
                IAstParser<E> newParser = newState.getParser();
                IExprNode<E> parsedNode = newParser.parse(newState, input);
                nodeStack.push(stateTransition.createRootNode(parsedNode));
            } else if (token.type == TokenType.LEFT_BRACKET) {
                String openingBracket = token.value;
                String closingBracket = TokenUtils.getClosingBracket(openingBracket);
                List<IExprNode<E>> childrenNodes = this.collectChildren(input, openingBracket, closingBracket, state);
                nodeStack.push(this.exprNodeFactory.createBracketNode(openingBracket, closingBracket, childrenNodes));
            } else if (token.type == TokenType.OPERATOR) {
                Operator op;
                if (!pushedNonOperatorLastLoop) {
                    op = this.operators.getUnaryOperator(token.value);
                    Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"No unary version of operator: %s", (Object[])new Object[]{token.value});
                } else {
                    op = this.operators.getBinaryOperator(token.value);
                    Preconditions.checkArgument((op != null ? 1 : 0) != 0, (String)"Invalid operator: %s", (Object[])new Object[]{token.value});
                }
                this.pushOperator(nodeStack, operatorStack, op);
                pushedNonOperatorThisLoop = false;
            } else {
                throw new InvalidTokenException(token);
            }
            if (pushedNonOperatorLastLoop && pushedNonOperatorThisLoop) {
                IExprNode<E> thisLoopPush = nodeStack.pop();
                this.pushOperator(nodeStack, operatorStack, defaultOperator);
                nodeStack.push(thisLoopPush);
            }
            pushedNonOperatorLastLoop = pushedNonOperatorThisLoop;
        }
        while (!operatorStack.isEmpty()) {
            Operator op = (Operator)operatorStack.pop();
            this.pushOperator(nodeStack, op);
        }
        if (nodeStack.size() != 1) {
            throw new NonExpressionException("Stack: " + nodeStack.printContents());
        }
        return (IExprNode)nodeStack.pop();
    }

    private List<IExprNode<E>> collectChildren(PeekingIterator<Token> input, String openingBracket, String closingBracket, ICompilerState<E> compilerState) {
        ArrayList args = Lists.newArrayList();
        if (!input.hasNext()) {
            throw new UnmatchedBracketsException(openingBracket);
        }
        if (((Token)input.peek()).type == TokenType.RIGHT_BRACKET) {
            Token token = InfixParser.next(input);
            Preconditions.checkState((boolean)token.value.equals(closingBracket), (String)"Unmatched brackets: '%s' and '%s'", (Object[])new Object[]{openingBracket, token.value});
            return args;
        }
        while (true) {
            IAstParser<E> newParser = compilerState.getParser();
            IExprNode<E> parsedNode = newParser.parse(compilerState, input);
            args.add(parsedNode);
            Token token = InfixParser.next(input);
            if (token.type == TokenType.RIGHT_BRACKET) {
                if (!token.value.equals(closingBracket)) {
                    throw new UnmatchedBracketsException(openingBracket, token.value);
                }
                return args;
            }
            Preconditions.checkState((token.type == TokenType.SEPARATOR ? 1 : 0) != 0, (String)"Expected arg separator, got %s", (Object[])new Object[]{token});
        }
    }

    private void pushOperator(Stack<IExprNode<E>> output, Stack<Operator<E>> operatorStack, Operator<E> newOp) {
        Operator<E> top;
        while (!operatorStack.isEmpty() && newOp.isLessThan(top = operatorStack.peek(0))) {
            operatorStack.pop();
            this.pushOperator(output, top);
        }
        operatorStack.push(newOp);
    }

    private void pushOperator(Stack<IExprNode<E>> nodeStack, Operator<E> op) {
        if (op instanceof BinaryOperator) {
            IExprNode<E> right = nodeStack.pop();
            IExprNode<E> left = nodeStack.pop();
            nodeStack.push(this.exprNodeFactory.createBinaryOpNode((BinaryOperator)op, left, right));
        } else if (op instanceof UnaryOperator) {
            IExprNode<E> arg = nodeStack.pop();
            nodeStack.push(this.exprNodeFactory.createUnaryOpNode((UnaryOperator)op, arg));
        } else {
            throw new IllegalStateException("Unknown type of operator: " + op.getClass());
        }
    }
}

