/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.ICallable;
import openmods.calc.SymbolMap;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.IBindPattern;
import openmods.calc.types.multi.TypedCalcUtils;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class Closure
implements ICallable<TypedValue> {
    private final Code code;
    private final SymbolMap<TypedValue> scopeSymbols;
    private final List<IBindPattern> args;

    public Closure(SymbolMap<TypedValue> scopeSymbols, Code code, List<IBindPattern> args) {
        this.code = code;
        this.scopeSymbols = scopeSymbols;
        this.args = ImmutableList.copyOf(args);
    }

    @Override
    public void call(Frame<TypedValue> callsite, OptionalInt argumentsCount, OptionalInt returnsCount) {
        TypedCalcUtils.expectExactArgCount(argumentsCount, this.args.size());
        Frame<TypedValue> executionFrame = FrameFactory.newClosureFrame(this.scopeSymbols, callsite, this.args.size());
        Stack<TypedValue> executionStack = executionFrame.stack();
        SymbolMap<TypedValue> executionSymbols = executionFrame.symbols();
        Iterator<TypedValue> argValues = executionStack.iterator();
        for (IBindPattern argPattern : this.args) {
            TypedValue argValue = argValues.next();
            TypedCalcUtils.matchPattern(argPattern, executionFrame, executionSymbols, argValue);
        }
        executionStack.clear();
        this.code.execute(executionFrame);
        TypedCalcUtils.expectExactReturnCount(returnsCount, executionStack.size());
    }
}

