/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openmods.reflection.FieldAccess;
import openmods.utils.CollectionUtils;

public class RecipeUtils {
    private static final ItemStack[] EMPTY_ITEM_STACK_ARRAY = new ItemStack[0];
    private static FieldAccess<Integer> shapedOreRecipeWidth = FieldAccess.create(ShapedOreRecipe.class, "width");
    private static FieldAccess<Integer> shapedOreRecipeHeight = FieldAccess.create(ShapedOreRecipe.class, "height");

    public static List<IRecipe> getVanillaRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    public static IRecipe getFirstRecipeForItemStack(ItemStack resultingItem) {
        for (IRecipe recipe : RecipeUtils.getVanillaRecipes()) {
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        IRecipe recipe = RecipeUtils.getFirstRecipeForItemStack(resultingItem);
        if (recipe == null) {
            return null;
        }
        Object[] input = RecipeUtils.getRecipeInput(recipe);
        return input != null ? RecipeUtils.convertToStacks(input) : null;
    }

    public static ItemStack[] convertToStacks(Object[] input) {
        ItemStack[] result = new ItemStack[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = RecipeUtils.convertToStack(input[i]);
        }
        return result;
    }

    public static ItemStack convertToStack(Object obj) {
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List) {
            List list = (List)obj;
            entry = (ItemStack)CollectionUtils.getRandom(list);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    public static Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeUtils.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(EMPTY_ITEM_STACK_ARRAY);
        }
        return null;
    }

    private static Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        int width = shapedOreRecipeWidth.get(recipe);
        Object[] input = recipe.getInput();
        int inputIndex = 0;
        Object[] grid = new Object[9];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int outputIndex = y * 3 + x;
                if (x < width && inputIndex < input.length) {
                    grid[outputIndex] = input[inputIndex];
                    ++inputIndex;
                    continue;
                }
                grid[outputIndex] = null;
            }
        }
        return grid;
    }

    private static void addOreRecipeEntry(InputBuilder builder, int slot, Object value) {
        if (value instanceof ItemStack) {
            builder.add(slot, (ItemStack)value);
        } else if (value instanceof Collection) {
            ArrayList variants = Lists.newArrayList();
            for (ItemStack stack : (Collection)value) {
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    Item item = stack.func_77973_b();
                    item.func_150895_a(item, null, (List)variants);
                    continue;
                }
                variants.add(stack);
            }
            builder.add(slot, variants);
        }
    }

    public static ItemStack[][] getFullRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return RecipeUtils.getFullRecipeInput((ShapelessOreRecipe)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeUtils.getFullRecipeInput((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return RecipeUtils.getFullRecipeInput((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapelessRecipes) {
            return RecipeUtils.getFullRecipeInput((ShapelessRecipes)recipe);
        }
        return null;
    }

    public static ItemStack[][] getFullRecipeInput(ShapelessOreRecipe recipe) {
        ArrayList inputs = recipe.getInput();
        int size = inputs.size();
        InputBuilder builder = new InputBuilder(size);
        for (int i = 0; i < size; ++i) {
            Object input = inputs.get(i);
            RecipeUtils.addOreRecipeEntry(builder, i, input);
        }
        return builder.build();
    }

    public static ItemStack[][] getFullRecipeInput(ShapedOreRecipe recipe) {
        InputBuilder builder = new InputBuilder(9);
        int width = shapedOreRecipeWidth.get(recipe);
        int height = shapedOreRecipeHeight.get(recipe);
        Object[] input = recipe.getInput();
        int inputIndex = 0;
        for (int row = 0; row < height; ++row) {
            for (int column = 0; column < width; ++column) {
                int outputIndex = row * 3 + column;
                RecipeUtils.addOreRecipeEntry(builder, outputIndex, input[inputIndex]);
                ++inputIndex;
            }
        }
        return builder.build();
    }

    public static ItemStack[][] getFullRecipeInput(ShapedRecipes recipe) {
        InputBuilder builder = new InputBuilder(9);
        ItemStack[] input = recipe.field_77574_d;
        int inputIndex = 0;
        for (int row = 0; row < recipe.field_77577_c; ++row) {
            for (int column = 0; column < recipe.field_77576_b; ++column) {
                int outputIndex = row * 3 + column;
                builder.add(outputIndex, input[inputIndex]);
                ++inputIndex;
            }
        }
        return builder.build();
    }

    public static ItemStack[][] getFullRecipeInput(ShapelessRecipes recipe) {
        InputBuilder builder = new InputBuilder(9);
        List input = recipe.field_77579_b;
        for (int i = 0; i < recipe.func_77570_a(); ++i) {
            builder.add(i, (ItemStack)input.get(i));
        }
        return builder.build();
    }

    public static class InputBuilder {
        private static final ItemStack[] EMPTY_SLOT = new ItemStack[0];
        private static final Function<ItemStack, ItemStack> COPY_TRANSFORM = new Function<ItemStack, ItemStack>(){

            @Nullable
            public ItemStack apply(@Nullable ItemStack input) {
                return input != null ? input.func_77946_l() : null;
            }
        };
        private final ItemStack[][] slots;

        public InputBuilder(int size) {
            this.slots = new ItemStack[size][];
        }

        public void add(int slot, ItemStack stack) {
            ItemStack[] itemStackArray;
            if (stack == null) {
                itemStackArray = EMPTY_SLOT;
            } else {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = stack.func_77946_l();
            }
            this.slots[slot] = itemStackArray;
        }

        public void add(int slot, ItemStack[] stacks) {
            this.slots[slot] = CollectionUtils.transform(stacks, COPY_TRANSFORM);
        }

        public void add(int slot, Collection<ItemStack> stacks) {
            this.slots[slot] = CollectionUtils.transform(stacks, COPY_TRANSFORM);
        }

        public ItemStack[][] build() {
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] != null) continue;
                this.slots[i] = EMPTY_SLOT;
            }
            return this.slots;
        }
    }
}

