/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openperipheral.api.architecture.IArchitectureChecker;

public class ArchitectureChecker
implements IArchitectureChecker {
    public static final ArchitectureChecker INSTANCE = new ArchitectureChecker();
    private Map<String, IArchitecturePredicate> architectureCheckers = Maps.newHashMap();

    @Override
    public Set<String> knownArchitectures() {
        return Collections.unmodifiableSet(this.architectureCheckers.keySet());
    }

    @Override
    public boolean isEnabled(String architecture) {
        IArchitecturePredicate checker = this.architectureCheckers.get(architecture);
        return checker != null ? checker.isEnabled() : false;
    }

    public void register(String architecture, IArchitecturePredicate predicate) {
        IArchitecturePredicate prev = this.architectureCheckers.put(architecture, predicate);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate checker for architecture '%s', '%s' -> '%s'", (Object[])new Object[]{architecture, prev, predicate});
    }

    public static interface IArchitecturePredicate {
        public boolean isEnabled();
    }
}

