/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import openperipheral.adapter.property.IFieldManipulator;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.ISinglePropertyAccessHandler;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.api.converter.IConverter;
import org.apache.commons.lang3.ArrayUtils;

public class GetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final IFieldManipulator manipulator;
    private final ISinglePropertyAccessHandler accessHandler;

    public GetterExecutor(Field field, IFieldManipulator manipulator, ISinglePropertyAccessHandler accessHandler) {
        this.field = field;
        this.manipulator = manipulator;
        this.accessHandler = accessHandler;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        Preconditions.checkArgument((args.length == 0 ? 1 : 0) != 0, (Object)"Getter has no arguments");
        Object target = PropertyUtils.getContents(owner, this.field);
        this.accessHandler.onGet(owner, target, this.field);
        Object result = this.manipulator.getField(owner, target, this.field);
        Object converted = converter.fromJava(result);
        return ArrayUtils.toArray((Object[])new Object[]{converted});
    }
}

