/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import openperipheral.adapter.property.IFieldManipulator;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.IIndexedPropertyAccessHandler;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.ISinglePropertyAccessHandler;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.api.converter.IConverter;
import org.apache.commons.lang3.ArrayUtils;

public class MergedGetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final IFieldManipulator manipulator;
    private final ISinglePropertyAccessHandler singleAccessHandler;
    private final IIndexedFieldManipulator indexedManipulator;
    private final IndexedTypeInfo indexedTypeInfo;
    private final IIndexedPropertyAccessHandler indexedAccessHandler;

    public MergedGetterExecutor(Field field, IFieldManipulator manipulator, ISinglePropertyAccessHandler singleAccessHandler, IIndexedFieldManipulator indexedManipulator, IndexedTypeInfo indexedTypeInfo, IIndexedPropertyAccessHandler indexedAccessHandler) {
        this.field = field;
        this.manipulator = manipulator;
        this.singleAccessHandler = singleAccessHandler;
        this.indexedManipulator = indexedManipulator;
        this.indexedTypeInfo = indexedTypeInfo;
        this.indexedAccessHandler = indexedAccessHandler;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        Object result;
        if (args.length == 0) {
            Object target = PropertyUtils.getContents(owner, this.field);
            this.singleAccessHandler.onGet(owner, target, this.field);
            result = this.manipulator.getField(owner, target, this.field);
        } else if (args.length == 1) {
            Object key = converter.toJava(args[0], this.indexedTypeInfo.keyType);
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Invalid index");
            Object target = PropertyUtils.getContents(owner, this.field);
            this.indexedAccessHandler.onGet(owner, target, this.field, key);
            result = this.indexedManipulator.getField(owner, target, this.field, key);
        } else {
            throw new IllegalArgumentException("Getter can have at most one parameter (index)");
        }
        Object converted = converter.fromJava(result);
        return ArrayUtils.toArray((Object[])new Object[]{converted});
    }
}

