/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td;

import cofh.lib.util.helpers.BlockHelper;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.td.LPItemDuct;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.IRouteProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TDDuctInformationProvider
implements IPipeInformationProvider,
IRouteProvider {
    private final TileItemDuct duct;

    public TDDuctInformationProvider(TileItemDuct duct) {
        this.duct = duct;
    }

    @Override
    public boolean isCorrect() {
        return this.duct != null && !this.duct.func_145837_r() && SimpleServiceLocator.thermalDynamicsProxy.isActive();
    }

    @Override
    public int getX() {
        return this.duct.field_145851_c;
    }

    @Override
    public int getY() {
        return this.duct.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.duct.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.duct.func_145831_w();
    }

    @Override
    public boolean isRouterInitialized() {
        return !this.duct.func_145837_r();
    }

    @Override
    public boolean isRoutingPipe() {
        return false;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity getTile(ForgeDirection direction) {
        return BlockHelper.getAdjacentTileEntity((TileEntity)this.duct, (ForgeDirection)direction);
    }

    @Override
    public boolean isFirewallPipe() {
        return false;
    }

    @Override
    public IFilter getFirewallFilter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TileEntity getTile() {
        return this.duct;
    }

    @Override
    public boolean divideNetwork() {
        return false;
    }

    @Override
    public boolean powerOnly() {
        return false;
    }

    @Override
    public boolean isOnewayPipe() {
        return false;
    }

    @Override
    public boolean isOutputOpen(ForgeDirection direction) {
        return this.duct.isSideConnected((byte)direction.ordinal());
    }

    @Override
    public boolean canConnect(TileEntity to, ForgeDirection direction, boolean ignoreSystemDisconnect) {
        TileEntity connection = this.duct.getAdjTileEntitySafe(direction.ordinal());
        if (!(connection instanceof TileTDBase)) {
            return false;
        }
        if (this.duct.isBlockedSide(direction.ordinal())) {
            return false;
        }
        if (connection instanceof LPItemDuct) {
            return !((LPItemDuct)connection).isLPBlockedSide(direction.getOpposite().ordinal(), ignoreSystemDisconnect);
        }
        return !((TileTDBase)connection).isBlockedSide(direction.getOpposite().ordinal());
    }

    @Override
    public double getDistance() {
        return Math.max(this.duct.getDuctType().pathWeight, 0);
    }

    @Override
    public boolean isItemPipe() {
        return true;
    }

    @Override
    public boolean isFluidPipe() {
        return false;
    }

    @Override
    public boolean isPowerPipe() {
        return false;
    }

    @Override
    public double getDistanceTo(int destinationint, ForgeDirection ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<LPPosition> visited) {
        if (traveled >= max) {
            return 2.147483647E9;
        }
        IRouter destination = SimpleServiceLocator.routerManager.getRouter(destinationint);
        if (destination == null) {
            return 2.147483647E9;
        }
        LinkedList paramIterable = this.duct.getCache((boolean)true).outputRoutes;
        double closesedConnection = 2.147483647E9;
        for (Route localRoute1 : paramIterable) {
            LPPosition pos;
            if (!(localRoute1.endPoint instanceof LPItemDuct)) continue;
            LPItemDuct lpDuct = (LPItemDuct)localRoute1.endPoint;
            if (traveled + (double)localRoute1.pathWeight > max || visited.contains(pos = new LPPosition(lpDuct.pipe))) continue;
            visited.add(pos);
            double distance = lpDuct.pipe.getDistanceTo(destinationint, ForgeDirection.getOrientation((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1)).getOpposite(), ident, isActive, traveled + (double)localRoute1.pathWeight, Math.min(max, closesedConnection), visited);
            visited.remove(pos);
            if (distance == 2.147483647E9 || !(distance + (double)localRoute1.pathWeight < closesedConnection)) continue;
            closesedConnection = distance + (double)localRoute1.pathWeight;
        }
        return closesedConnection;
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (item instanceof LPTravelingItem.LPTravelingItemServer) {
            IRouter destination;
            LPTravelingItem.LPTravelingItemServer serverItem = (LPTravelingItem.LPTravelingItemServer)item;
            int id = serverItem.getInfo().destinationint;
            if (id == -1) {
                id = SimpleServiceLocator.routerManager.getIDforUUID(serverItem.getInfo().destinationUUID);
            }
            if ((destination = SimpleServiceLocator.routerManager.getRouter(id)) == null) {
                return false;
            }
            RouteCache routes = this.duct.getCache(true);
            LinkedList paramIterable = routes.outputRoutes;
            Route route = null;
            Object cache = null;
            Triplet<Integer, ItemIdentifier, Boolean> key = new Triplet<Integer, ItemIdentifier, Boolean>(id, item.getItemIdentifierStack().getItem(), serverItem.getInfo()._transportMode == IRoutedItem.TransportMode.Active);
            if (this.duct instanceof ILPTEInformation && ((ILPTEInformation)this.duct).getObject() != null) {
                cache = ((ILPTEInformation)this.duct).getObject().getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Routing, key);
            }
            if (cache instanceof Route && !routes.outputRoutes.contains(route = (Route)cache)) {
                route = null;
            }
            if (route == null) {
                Pair<Double, Route> closesedConnection = null;
                ArrayList<LPPosition> visited = new ArrayList<LPPosition>();
                visited.add(new LPPosition(from));
                for (Route localRoute1 : paramIterable) {
                    LPPosition pos;
                    if (!(localRoute1.endPoint instanceof LPItemDuct)) continue;
                    LPItemDuct lpDuct = (LPItemDuct)localRoute1.endPoint;
                    double max = 2.147483647E9;
                    if (closesedConnection != null) {
                        max = (Double)closesedConnection.getValue1();
                    }
                    if (visited.contains(pos = new LPPosition(lpDuct.pipe))) continue;
                    visited.add(pos);
                    double distance = lpDuct.pipe.getDistanceTo(id, ForgeDirection.getOrientation((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1)).getOpposite(), item.getItemIdentifierStack().getItem(), serverItem.getInfo()._transportMode == IRoutedItem.TransportMode.Active, localRoute1.pathWeight, max, visited);
                    visited.remove(pos);
                    if (distance == 2.147483647E9 || closesedConnection != null && !(distance + (double)localRoute1.pathDirections.size() < (Double)closesedConnection.getValue1())) continue;
                    closesedConnection = new Pair<Double, Route>(distance + (double)localRoute1.pathWeight, localRoute1);
                }
                if (closesedConnection != null) {
                    route = (Route)closesedConnection.getValue2();
                }
            }
            if (route != null) {
                if (this.duct instanceof ILPTEInformation && ((ILPTEInformation)this.duct).getObject() != null) {
                    ((ILPTEInformation)this.duct).getObject().getCacheHolder().setCache(CacheHolder.CacheTypes.Routing, key, route);
                }
                TravelingItem travelItem = new TravelingItem(item.getItemIdentifierStack().makeNormalStack(), (IMultiBlock)this.duct, route.copy(), (byte)serverItem.output.ordinal(), 1);
                travelItem.lpRoutingInformation = serverItem.getInfo();
                this.duct.insertNewItem(travelItem);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(ForgeDirection side) {
        if (this.duct.myGrid == null) {
            return;
        }
        this.duct.myGrid.destroyAndRecreate();
    }

    @Override
    public List<IRouteProvider.RouteInfo> getConnectedPipes(ForgeDirection from) {
        ArrayList<IRouteProvider.RouteInfo> list = new ArrayList<IRouteProvider.RouteInfo>();
        if (this.duct.internalGrid == null) {
            return null;
        }
        LinkedList paramIterable = this.duct.getCache((boolean)true).outputRoutes;
        for (Route localRoute1 : paramIterable) {
            if (!(localRoute1.endPoint instanceof LPItemDuct)) continue;
            LPItemDuct lpDuct = (LPItemDuct)localRoute1.endPoint;
            list.add(new IRouteProvider.RouteInfo(lpDuct.pipe, localRoute1.pathWeight, ForgeDirection.getOrientation((int)localRoute1.pathDirections.get(localRoute1.pathDirections.size() - 1))));
        }
        return list;
    }
}

